/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.debug;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import redempt.redlex.data.TokenType;
import redempt.redlex.debug.DebugEntry;

public class DebugHistory {
    private int[][] breaks;
    private Deque<TokenType> stack = new ArrayDeque<TokenType>();
    private List<DebugEntry> entries = new ArrayList<DebugEntry>();

    public void setString(String str) {
        this.stack.clear();
        this.entries.clear();
        int line = 1;
        int col = 1;
        this.breaks = new int[str.length() + 1][];
        for (int i = 0; i < str.length(); ++i) {
            this.breaks[i] = new int[]{line++, col++};
            if (str.charAt(i) != '\n') continue;
            col = 1;
        }
        this.breaks[this.breaks.length - 1] = this.breaks[this.breaks.length - 2];
    }

    public void begin(TokenType type, int pos) {
        if (type.getName() == null) {
            return;
        }
        this.entries.add(new DebugEntry(type, this.breaks[pos][0], this.breaks[pos][1], this.stack.size(), 0));
        this.stack.add(type);
    }

    public void result(TokenType type, int pos, boolean success) {
        if (type.getName() == null) {
            return;
        }
        this.stack.removeLast();
        this.entries.add(new DebugEntry(type, this.breaks[pos][0], this.breaks[pos][1], this.stack.size(), success ? 2 : 1));
    }

    public DebugHistory filter(String ... names) {
        HashSet<String> matches = new HashSet<String>(Arrays.asList(names));
        this.entries.removeIf(e -> matches.contains(e.getOwner().getName()));
        return this;
    }

    public DebugHistory filter(Predicate<String> nameFilter) {
        this.entries.removeIf(e -> nameFilter.test(e.getOwner().getName()));
        return this;
    }

    public String toString() {
        return this.entries.stream().map(DebugEntry::toString).collect(Collectors.joining("\n"));
    }
}

