/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.debug;

import redempt.redlex.data.TokenType;

public class DebugEntry {
    private int status;
    private int row;
    private int col;
    private int depth;
    private TokenType owner;

    public DebugEntry(TokenType owner, int row, int col, int depth, int status) {
        this.owner = owner;
        this.row = row;
        this.col = col;
        this.status = status;
        this.depth = depth;
    }

    public TokenType getOwner() {
        return this.owner;
    }

    public int getLine() {
        return this.row;
    }

    public int getCol() {
        return this.getCol();
    }

    public int getStatus() {
        return this.status;
    }

    public int getDepth() {
        return this.depth;
    }

    private String getStatusString() {
        switch (this.status) {
            case 0: {
                return "began tokenize";
            }
            case 1: {
                return "failed to tokenize";
            }
            case 2: {
                return "successfully tokenized";
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            out.append("  ");
        }
        out.append(this.owner.getName()).append(" ").append(this.getStatusString()).append(" at line ").append(this.row).append(", column ").append(this.col);
        return out.toString();
    }
}

