/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.data;

import java.util.HashMap;
import java.util.Map;
import redempt.redlex.data.TokenType;
import redempt.redlex.token.ListToken;

public class LexContext {
    private int lastPos;
    private TokenType token;
    private Map<TokenType, Integer> map = new HashMap<TokenType, Integer>();

    public LexContext() {
    }

    public LexContext(int pos) {
        this.lastPos = pos;
    }

    public int getLastPos() {
        return this.lastPos;
    }

    public boolean update(int pos, TokenType type) {
        if (type.getName() == null) {
            return this.shouldRecurse(pos, type);
        }
        if (pos > this.lastPos) {
            this.lastPos = pos;
            this.token = type;
        }
        return this.shouldRecurse(pos, type);
    }

    private boolean shouldRecurse(int pos, TokenType type) {
        if (!(type instanceof ListToken)) {
            return false;
        }
        if (this.map.putIfAbsent(type, pos) == null) {
            return true;
        }
        int cur = this.map.get(type);
        if (pos > cur) {
            this.map.put(type, pos);
            return true;
        }
        return false;
    }

    public TokenType getLastToken() {
        return this.token;
    }
}

