/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CharTree {
    private Node root = new Node();

    public void set(String str) {
        Node node = this.root;
        for (int i = 0; i < str.length(); ++i) {
            node = node.addChild(str.charAt(i));
        }
        node.setMapped();
    }

    public int findForward(String str, int start) {
        int i;
        Node node = this.root;
        int max = -1;
        for (i = start; node != null && i < str.length(); node = node.getChild(str.charAt(i)), ++i) {
            if (!node.isMapped()) continue;
            max = i;
        }
        if (node != null && node.isMapped()) {
            return i;
        }
        return max;
    }

    public Set<Character> getFirstChars() {
        return this.root.children.keySet();
    }

    private static class Node {
        public Map<Character, Node> children;
        private boolean mapped = false;

        private Node() {
        }

        public Node getChild(char c) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(Character.valueOf(c));
        }

        public void setMapped() {
            this.mapped = true;
        }

        public boolean isMapped() {
            return this.mapped;
        }

        public Node addChild(char c) {
            if (this.children == null) {
                this.children = new HashMap<Character, Node>();
            }
            return this.children.computeIfAbsent(Character.valueOf(c), k -> new Node());
        }
    }
}

