/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import redempt.redlex.data.TokenType;

public class CharGroupToken
extends TokenType {
    private int min;
    private int max;
    private boolean inverted;

    public CharGroupToken(String name, int min, int max, boolean inverted) {
        super(name);
        this.min = min;
        this.max = max;
        this.inverted = inverted;
    }

    public CharGroupToken(String name, int min, int max) {
        this(name, min, max, false);
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        char c = input.charAt(pos);
        return this.inverted ^ (c <= this.max && c >= this.min);
    }

    @Override
    public boolean lengthMatches(int length) {
        return length == 1;
    }

    @Override
    public int minLength() {
        return 1;
    }

    @Override
    public int maxLength() {
        return 1;
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        if (this.inverted) {
            return Collections.singletonList(null);
        }
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = this.min; i < this.max; ++i) {
            list.add(Character.valueOf((char)i));
        }
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.inverted);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharGroupToken)) {
            return false;
        }
        CharGroupToken token = (CharGroupToken)o;
        return token.inverted == this.inverted && token.min == this.min && token.max == this.max;
    }
}

