/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.bnf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import redempt.redlex.bnf.BNFLexer;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;
import redempt.redlex.exception.BNFException;
import redempt.redlex.processing.CullStrategy;
import redempt.redlex.processing.Lexer;
import redempt.redlex.processing.TokenFilter;
import redempt.redlex.processing.TraversalOrder;
import redempt.redlex.token.CharGroupToken;
import redempt.redlex.token.CharSetToken;
import redempt.redlex.token.ChoiceToken;
import redempt.redlex.token.EndOfFileToken;
import redempt.redlex.token.ListToken;
import redempt.redlex.token.NotToken;
import redempt.redlex.token.PlaceholderToken;
import redempt.redlex.token.RepeatingToken;
import redempt.redlex.token.StringChoiceToken;
import redempt.redlex.token.StringToken;

public class BNFParser {
    private static Lexer lexer = BNFLexer.getLexer();

    public static Lexer createLexer(String input) {
        return new Lexer(BNFParser.parse(input));
    }

    public static Lexer createLexer(Path path) {
        try {
            String contents = Files.lines(path).collect(Collectors.joining("\n"));
            return BNFParser.createLexer(contents);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Lexer createLexer(InputStream stream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = "";
            StringJoiner joiner = new StringJoiner("\n");
            while ((line = reader.readLine()) != null) {
                joiner.add(line);
            }
            return BNFParser.createLexer(joiner.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static TokenType parse(String input) {
        void var4_10;
        Token token = lexer.tokenize(input);
        Map<String, List<Token>> map = token.allByNames(TraversalOrder.DEPTH_LEAF_FIRST, "escapeSequence", "statementOpt", "token", "sentence", "nested");
        for (Token token2 : map.get("escapeSequence")) {
            Token anyChar = token2.firstByName("anyChar");
            token2.firstByName("escape").setValue("");
            switch (anyChar.getValue().charAt(0)) {
                case 'n': {
                    anyChar.setValue("\n");
                    break;
                }
                case 't': {
                    anyChar.setValue("\t");
                    break;
                }
            }
        }
        for (Token token3 : map.get("statementOpt")) {
            token3.liftChildren();
        }
        HashMap<String, TokenType> tokens = new HashMap<String, TokenType>();
        for (Token t : map.get("token")) {
            TokenType type = BNFParser.createToken(t, tokens);
            t.replaceWith(type);
        }
        for (Token t : map.get("sentence")) {
            String name = t.firstByName("word").getValue();
            TokenType type = BNFParser.processSentence(t);
            if (!(type instanceof PlaceholderToken)) {
                type.setName(name);
            }
            tokens.put(name, type);
        }
        TokenType tokenType = (TokenType)tokens.get("root");
        if (tokenType == null) {
            throw new BNFException("No root node specified");
        }
        HashSet<String> used = new HashSet<String>();
        while (var4_10 instanceof PlaceholderToken) {
            if (!used.add(var4_10.getName())) {
                throw new BNFException("Circular reference or undefined tokens: " + String.join((CharSequence)", ", used));
            }
            TokenType tokenType2 = (TokenType)tokens.get(var4_10.getName());
        }
        var4_10.replacePlaceholders(tokens);
        return var4_10;
    }

    private static TokenType createToken(Token input, Map<String, TokenType> map) {
        Token[] children;
        boolean not = (children = input.getChildren())[0].getType().getName().equals("!");
        Token token = children[not ? 1 : 0];
        TokenType type = null;
        switch (token.getType().getName()) {
            case "string": {
                type = BNFParser.createString(token.firstByName("strOpt"), token.firstByName("insensitive") == null);
                break;
            }
            case "charset": {
                type = BNFParser.createCharset(token);
                break;
            }
            case "chargroup": {
                type = BNFParser.createCharGroup(token);
                break;
            }
            case "word": {
                type = BNFParser.createTokenReference(token);
                map.putIfAbsent(type.getName(), type);
                break;
            }
            case "eof": {
                type = new EndOfFileToken(null);
            }
        }
        Token modifier = input.firstByName("modifier");
        type = BNFParser.processModifier(type, modifier);
        if (not) {
            type = new NotToken(null, type);
        }
        return type;
    }

    private static TokenType processModifier(TokenType type, Token modifier) {
        if (modifier == null) {
            return type;
        }
        switch (modifier.getValue().charAt(0)) {
            case '+': {
                type = new RepeatingToken(null, type);
                break;
            }
            case '*': {
                type = new RepeatingToken(null, type, 0, Integer.MAX_VALUE);
                break;
            }
            case '?': {
                type = new RepeatingToken(null, type, 0, 1);
                break;
            }
            case '{': {
                int[] times = BNFParser.parseQuantifier(modifier.getValue());
                type = new RepeatingToken(null, type, times[0], times[1]);
            }
        }
        return type;
    }

    private static int[] parseQuantifier(String quantifier) {
        int commaIndex = quantifier.indexOf(44);
        if (commaIndex == -1) {
            int num = Integer.parseInt(quantifier.substring(1, quantifier.length() - 1));
            return new int[]{num, num};
        }
        String before = quantifier.substring(1, commaIndex);
        String after = quantifier.substring(commaIndex + 1, quantifier.length() - 1);
        int min = before.length() == 0 ? 0 : Integer.parseInt(before);
        int max = after.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(after);
        return new int[]{min, max};
    }

    private static TokenType processSentence(Token sentence) {
        for (Token t : sentence.allByName(TraversalOrder.DEPTH_LEAF_FIRST, "nested")) {
            Token statement = t.firstByName("statement");
            TokenType token = BNFParser.createStatement(statement);
            Token mod = t.firstByName("modifier");
            if (mod != null) {
                token = BNFParser.processModifier(token, mod);
            }
            if (t.firstByName("!") != null) {
                token = new NotToken(null, token);
            }
            t.replaceWith(token);
        }
        return BNFParser.createStatement(sentence.firstByName("statement"));
    }

    private static TokenType createStatement(Token statement) {
        statement.cull(TokenFilter.byName(CullStrategy.LIFT_CHILDREN, "statement"));
        List<List<Token>> split = statement.splitChildren("|");
        ArrayList<TokenType> merged = new ArrayList<TokenType>();
        for (List<Token> list : split) {
            if (list.size() == 1) {
                merged.add((TokenType)list.get(0).getObject());
                continue;
            }
            TokenType[] arr = new TokenType[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = (TokenType)list.get(i).getObject();
            }
            merged.add(new ListToken(null, arr));
        }
        if (merged.size() == 1) {
            return (TokenType)merged.get(0);
        }
        if (merged.size() >= 3 && merged.stream().allMatch(t -> t instanceof StringToken && ((StringToken)t).isCaseSensitive())) {
            return new StringChoiceToken(null, (String[])merged.stream().map(StringToken.class::cast).map(StringToken::getString).toArray(String[]::new));
        }
        return new ChoiceToken(null, merged.toArray(new TokenType[merged.size()]));
    }

    private static TokenType createString(Token strOpt, boolean caseSensitive) {
        if (strOpt == null) {
            return new StringToken(null, "");
        }
        String val = strOpt.joinLeaves("");
        return new StringToken("'" + val, strOpt.joinLeaves(""), caseSensitive);
    }

    private static TokenType createTokenReference(Token t) {
        return new PlaceholderToken(t.getValue());
    }

    private static TokenType createCharset(Token token) {
        Token setOpt;
        Token caret = token.firstByName("^");
        if (caret != null) {
            caret.remove();
        }
        if ((setOpt = token.firstByName("setOpt")) == null) {
            return new CharGroupToken(null, -1, -1, caret != null);
        }
        String str = setOpt.joinLeaves("");
        if (str.length() == 1) {
            char c = str.charAt(0);
            return new CharGroupToken(null, c, c, caret != null);
        }
        return new CharSetToken(null, caret != null, str.toCharArray());
    }

    private static TokenType createCharGroup(Token charGroup) {
        Token caret = charGroup.firstByName("^");
        if (caret != null) {
            caret.remove();
        }
        String set = charGroup.joinLeaves("");
        return new CharGroupToken(null, set.charAt(1), set.charAt(3), caret != null);
    }

    static {
        lexer.setUnnamedRule(CullStrategy.DELETE_ALL);
        lexer.setRetainEmpty(false);
        lexer.setRuleByName(CullStrategy.DELETE_ALL, "whitespace", "::=", "comment", "validChar");
        lexer.setRuleByName(CullStrategy.LIFT_CHILDREN, "modifiers", "statementList", "tokenOrNested", "tokenOrStatement", "tokenBase", "sentencesRep", "separator", "modifierChoice");
    }
}

