/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import redempt.redlex.data.CharTree;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class StringChoiceToken
extends TokenType {
    private CharTree tree = new CharTree();
    private int min = Integer.MAX_VALUE;
    private int max = 0;

    public StringChoiceToken(String name, String[] choices) {
        super(name);
        for (String choice : choices) {
            this.tree.set(choice);
            this.min = Math.min(this.min, choice.length());
            this.max = Math.max(this.max, choice.length());
        }
    }

    @Override
    public Token findForward(String str, int pos, LexContext ctx) {
        ctx.update(pos, this);
        int len = this.tree.findForward(str, pos);
        if (len == -1) {
            return null;
        }
        return new Token(this, str, pos, len, null);
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return false;
    }

    @Override
    public boolean lengthMatches(int length) {
        return length >= this.min && length <= this.max;
    }

    @Override
    public int minLength() {
        return this.min;
    }

    @Override
    public int maxLength() {
        return this.max;
    }
}

