/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class RepeatingToken
extends TokenType
implements ParentToken {
    private TokenType token;
    private int minMatches;
    private int maxMatches;

    public RepeatingToken(String name, TokenType token, int minMatches, int maxMatches) {
        super(name);
        this.token = token;
        this.minMatches = minMatches;
        this.maxMatches = maxMatches;
    }

    public RepeatingToken(String name, TokenType token) {
        this(name, token, 1, Integer.MAX_VALUE);
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return false;
    }

    @Override
    public Token findForward(String str, int pos, LexContext ctx) {
        Token inst;
        ctx.update(pos, this);
        ArrayList<Token> list = new ArrayList<Token>();
        int start = pos;
        while (pos < str.length() && list.size() < this.maxMatches && (inst = this.token.findForward(str, pos, ctx)) != null) {
            list.add(inst);
            pos += inst.length();
            if (inst.length() != 0) continue;
            break;
        }
        if (list.size() >= this.minMatches) {
            return new Token(this, str, start, pos, list.toArray(Token.EMPTY));
        }
        return null;
    }

    @Override
    public boolean lengthMatches(int length) {
        if (this.token.minLength() == this.token.maxLength()) {
            return length > 0 && length % this.token.maxLength() == 0;
        }
        return length >= this.token.minLength();
    }

    @Override
    public int minLength() {
        return this.token.minLength();
    }

    @Override
    public int maxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public TokenType[] getChildren() {
        return new TokenType[]{this.token};
    }

    @Override
    public void setChildren(TokenType[] children) {
        this.token = children[0];
    }
}

