/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class ChoiceToken
extends TokenType
implements ParentToken {
    private TokenType[] children;
    private int minLength = -1;
    private int maxLength = -1;

    public ChoiceToken(String name, TokenType ... children) {
        super(name);
        this.children = children;
    }

    private void initLength() {
        if (this.minLength != -1) {
            return;
        }
        for (TokenType child : this.children) {
            this.minLength = Math.min(child.minLength(), this.minLength);
            this.maxLength = Math.max(child.maxLength(), this.maxLength);
        }
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return false;
    }

    @Override
    public Token findForward(String str, int pos, LexContext ctx) {
        ctx.update(pos, this);
        for (TokenType child : this.children) {
            Token inst = child.findForward(str, pos, ctx);
            if (inst == null) continue;
            return new Token(this, inst.getBaseString(), inst.getStart(), inst.getEnd(), new Token[]{inst});
        }
        return null;
    }

    @Override
    public boolean lengthMatches(int length) {
        this.initLength();
        return length >= this.minLength && length <= this.maxLength;
    }

    @Override
    public int minLength() {
        this.initLength();
        return this.minLength;
    }

    @Override
    public int maxLength() {
        this.initLength();
        return this.maxLength;
    }

    @Override
    public TokenType[] getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(TokenType[] children) {
        this.children = children;
    }
}

