/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.HashSet;
import java.util.Set;
import redempt.redlex.data.TokenType;

public class CharSetToken
extends TokenType {
    private Set<Character> chars = new HashSet<Character>();
    private boolean inverted;

    public CharSetToken(String name, boolean inverted, char ... chars) {
        super(name);
        for (char c : chars) {
            this.chars.add(Character.valueOf(c));
        }
        this.inverted = inverted;
    }

    public CharSetToken(String name, char ... chars) {
        this(name, false, chars);
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return this.inverted ^ this.chars.contains(Character.valueOf(input.charAt(pos)));
    }

    @Override
    public boolean lengthMatches(int length) {
        return length == 1;
    }

    @Override
    public int minLength() {
        return 1;
    }

    @Override
    public int maxLength() {
        return 1;
    }
}

