/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.commandmanager.processing.CommandProcessUtils;

public class ContextProvider<T> {
    public static ContextProvider<ItemStack> mainHand = new ContextProvider<ItemStack>("mainhand", CommandProcessUtils.msg("mustHoldItem"), c -> {
        ItemStack item = c.getItemInHand();
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        return item.clone();
    });
    public static ContextProvider<Player> self = new ContextProvider<Player>("self", p -> p);
    private String name;
    private String error = null;
    private Function<Player, T> provider;

    public static ContextProvider<Boolean> assertProvider(String name, String error, Predicate<Player> assertion) {
        return new ContextProvider<Boolean>(name, error, c -> assertion.test((Player)c) ? Boolean.valueOf(true) : null);
    }

    public static ContextProvider<Boolean> assertProvider(String name, Predicate<Player> assertion) {
        return ContextProvider.assertProvider(name, null, assertion);
    }

    public ContextProvider(String name, Function<Player, T> provider) {
        if (name.contains(" ")) {
            throw new IllegalArgumentException("Context provider name cannot contain a space");
        }
        this.name = name;
        this.provider = provider;
    }

    public ContextProvider(String name, String error, Function<Player, T> provider) {
        this(name, provider);
        this.error = error;
    }

    public String getName() {
        return this.name;
    }

    public String getErrorMessage() {
        return this.error;
    }

    public <K> ContextProvider<K> map(String name, String error, Function<T, K> func) {
        return new ContextProvider<Object>(name, error, c -> {
            T obj = this.provide((Player)c);
            if (obj == null) {
                return null;
            }
            return func.apply(obj);
        });
    }

    public <K> ContextProvider<K> map(String name, String error, BiFunction<Player, T, K> func) {
        return new ContextProvider<Object>(name, error, c -> {
            T obj = this.provide((Player)c);
            if (obj == null) {
                return null;
            }
            return func.apply((Player)c, obj);
        });
    }

    public <K> ContextProvider<K> map(String name, Function<T, K> func) {
        return this.map(name, null, func);
    }

    public <K> ContextProvider<K> map(String name, BiFunction<Player, T, K> func) {
        return this.map(name, null, func);
    }

    protected T provide(Player sender) {
        return this.provider.apply(sender);
    }
}

