/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import redempt.redlib.commandmanager.processing.CommandProcessUtils;
import redempt.redlib.misc.FormatUtils;

public class Messages {
    private static Map<Plugin, Messages> all = new HashMap<Plugin, Messages>();
    private Plugin plugin;
    private Map<String, String> messages;
    private Map<String, String> defaults;
    private UnaryOperator<String> formatter = FormatUtils::color;

    public static Messages load(InputStream defaults, Path path) {
        try {
            String line;
            LinkedHashMap<String, String> messages = Files.exists(path, new LinkOption[0]) ? Messages.parse(Files.readAllLines(path)) : new LinkedHashMap();
            BufferedReader reader = new BufferedReader(new InputStreamReader(defaults));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            Map<String, String> defaultMap = Messages.parse(lines);
            boolean[] missing = new boolean[]{false};
            defaultMap.forEach((k, v) -> {
                if (!messages.containsKey(k)) {
                    messages.put((String)k, (String)v);
                    missing[0] = true;
                }
            });
            if (missing[0]) {
                Messages.write(messages, path);
            }
            return new Messages(null, messages, defaultMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Messages load(Plugin plugin, InputStream defaults, String filename) {
        Path path = plugin.getDataFolder().toPath().resolve(filename);
        Messages messages = Messages.load(defaults, path);
        messages.plugin = plugin;
        all.put(plugin, messages);
        return messages;
    }

    public static Messages getLoaded(Plugin plugin) {
        return all.get(plugin);
    }

    public static Messages load(Plugin plugin, InputStream defaults) {
        return Messages.load(plugin, defaults, "messages.txt");
    }

    public static Messages load(Plugin plugin) {
        return Messages.load(plugin, plugin.getResource("messages.txt"), "messages.txt");
    }

    public static String msg(String message) {
        Plugin plugin = CommandProcessUtils.getCallingPlugin();
        Messages msgs = all.get(plugin);
        if (msgs == null) {
            throw new IllegalStateException("Your plugin has not loaded any messages, or this method is being called from the wrong plugin");
        }
        return msgs.get(message);
    }

    private static Map<String, String> parse(List<String> input) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s : input) {
            if (s == null) break;
            int index = s.indexOf(58);
            map.put(s.substring(0, index), s.substring(index + 1).trim());
        }
        return map;
    }

    private static void write(Map<String, String> map, Path file) {
        List lines = map.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.toList());
        try {
            if (!Files.exists(file.getParent(), new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            Files.write(file, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private Messages(Plugin plugin, Map<String, String> messages, Map<String, String> defaults) {
        this.messages = messages;
        this.defaults = defaults;
        this.plugin = plugin;
    }

    public Messages setFormatter(UnaryOperator<String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String get(String msg) {
        String message = this.messages.getOrDefault(msg, this.defaults.get(msg));
        if (message == null) {
            throw new IllegalArgumentException("Message '" + msg + "' does not have an assigned or default value!");
        }
        return (String)this.formatter.apply(message);
    }
}

