/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.bukkit.command.CommandSender;

public class Constraint<T> {
    private BiPredicate<CommandSender, T> condition;
    private BiFunction<CommandSender, T, String> error;
    private String name;

    public static <T> Constraint<T> of(String error, BiPredicate<CommandSender, T> condition) {
        return new Constraint<Object>(condition, (c, v) -> error);
    }

    public static <T> Constraint<T> of(BiPredicate<CommandSender, T> condition) {
        return new Constraint<T>(condition, null);
    }

    public static <T> Constraint<T> of(Function<T, String> error, BiPredicate<CommandSender, T> condition) {
        return new Constraint<Object>(condition, (c, v) -> (String)error.apply(v));
    }

    public static <T> Constraint<T> of(BiFunction<CommandSender, T, String> error, BiPredicate<CommandSender, T> condition) {
        return new Constraint<T>(condition, error);
    }

    private Constraint(BiPredicate<CommandSender, T> condition, BiFunction<CommandSender, T, String> error) {
        this.condition = condition;
        this.error = error;
    }

    public Constraint<T> setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean test(CommandSender sender, Object arg) {
        return this.condition.test(sender, (CommandSender)arg);
    }

    public String getError(CommandSender sender, Object arg) {
        return this.error == null ? null : this.error.apply(sender, (CommandSender)arg);
    }
}

