/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.debug;

import java.util.HashSet;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;
import redempt.redlex.debug.DebugHistory;
import redempt.redlex.debug.DebugToken;
import redempt.redlex.processing.Lexer;

public class DebugLexer
extends Lexer {
    private DebugHistory history = ((DebugToken)this.getRoot()).getHistory();

    private static TokenType debug(TokenType root, DebugHistory history) {
        HashSet parents = new HashSet();
        root.walk(t -> {
            if (t instanceof ParentToken) {
                parents.add((ParentToken)((Object)t));
            }
        });
        for (ParentToken token : parents) {
            TokenType[] children = token.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i] = new DebugToken(children[i], history);
            }
            token.setChildren(children);
        }
        return new DebugToken(root, history);
    }

    public DebugLexer(TokenType root) {
        super(DebugLexer.debug(root, new DebugHistory()));
    }

    @Override
    public Token tokenize(String str) {
        return this.tokenize(str, false);
    }

    @Override
    public Token tokenize(String str, boolean errorOnFail) {
        this.history.setString(str);
        return super.tokenize(str, errorOnFail);
    }

    public DebugHistory getDebugHistory() {
        return this.history;
    }
}

