/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.bnf;

import java.util.Collections;
import java.util.HashMap;
import redempt.redlex.data.TokenType;
import redempt.redlex.processing.Lexer;
import redempt.redlex.token.CharGroupToken;
import redempt.redlex.token.CharSetToken;
import redempt.redlex.token.ChoiceToken;
import redempt.redlex.token.EndOfFileToken;
import redempt.redlex.token.ListToken;
import redempt.redlex.token.PlaceholderToken;
import redempt.redlex.token.RepeatingToken;
import redempt.redlex.token.StringToken;

class BNFLexer {
    private static TokenType commentPrefix = new StringToken("#", "#");
    private static TokenType escape = new StringToken("escape", "\\");
    private static TokenType anyChar = new CharGroupToken("anyChar", 0, 0, true);
    private static TokenType hexChar = new CharSetToken("hexChar", "0123456789abcdefABCDEF".toCharArray());
    private static TokenType unicodeSequence = new ListToken("unicodeEscape", new StringToken(null, "u"), new RepeatingToken("hexQuad", hexChar, 4, 4));
    private static TokenType escapeSequence = new ListToken("escapeSequence", escape, new ChoiceToken("escapeChoice", unicodeSequence, anyChar));
    private static TokenType obrack = new StringToken("[", "[");
    private static TokenType oparen = new StringToken(null, "(");
    private static TokenType caret = new StringToken("^", "^");
    private static TokenType optionalCaret = new RepeatingToken("^", caret, 0, 1);
    private static TokenType cbrack = new StringToken("]", "]");
    private static TokenType cparen = new StringToken(null, ")");
    private static TokenType whitespace = new CharSetToken("whitespace", ' ', '\t', '\r');
    private static TokenType newline = new StringToken("whitespace", "\n");
    private static TokenType newlineRep = new RepeatingToken("whitespace", newline);
    private static TokenType sep = new RepeatingToken("whitespace", whitespace);
    private static TokenType opsep = new RepeatingToken("whitespace", whitespace, 0, Integer.MAX_VALUE);
    private static TokenType lowerAlpha = new CharGroupToken(null, 97, 122);
    private static TokenType upperAlpha = new CharGroupToken(null, 65, 90);
    private static TokenType digit = new CharGroupToken(null, 48, 57);
    private static TokenType number = new RepeatingToken("number", digit);
    private static TokenType underscore = new StringToken("_", "_");
    private static TokenType validChar = new ChoiceToken("validChar", lowerAlpha, upperAlpha, digit, underscore);
    private static TokenType word = new RepeatingToken("word", validChar);
    private static TokenType equals = new StringToken("::=", "::=");
    private static TokenType eofToken = new StringToken("eof", "<eof>");
    private static TokenType quantifier = BNFLexer.quantifierType();
    private static TokenType basicModifier = new CharSetToken("modifier", '+', '?', '*');
    private static TokenType modifier = new ChoiceToken("modifierChoice", quantifier, basicModifier);
    private static TokenType modifierToken = new RepeatingToken("modifiers", modifier, 0, 1);
    private static TokenType notToken = new StringToken("!", "!");
    private static TokenType notOpt = new RepeatingToken("!", notToken, 0, 1);
    private static TokenType token = BNFLexer.tokenType();
    private static TokenType statement = BNFLexer.statementType();
    private static TokenType sentence = new ListToken("sentence", opsep, word, sep, equals, sep, statement);
    private static TokenType comment = BNFLexer.commentType();

    BNFLexer() {
    }

    public static Lexer getLexer() {
        return new Lexer(BNFLexer.rootType());
    }

    private static TokenType stringType() {
        RepeatingToken optI = new RepeatingToken("insensitive", new StringToken(null, "i"), 0, 1);
        CharGroupToken notQuote = new CharGroupToken("notQuote", 34, 34, true);
        ChoiceToken stringChar = new ChoiceToken("strChar", escapeSequence, notQuote);
        RepeatingToken stringRep = new RepeatingToken("strOpt", stringChar, 0, Integer.MAX_VALUE);
        StringToken quote = new StringToken("quote", "\"");
        ListToken string = new ListToken("string", optI, quote, stringRep, quote);
        return string;
    }

    private static TokenType commentType() {
        CharSetToken notNewline = new CharSetToken("notNewline", true, '\n');
        RepeatingToken notNewlineRep = new RepeatingToken("comment", notNewline, 0, Integer.MAX_VALUE);
        ListToken comment = new ListToken("comment", opsep, commentPrefix, notNewlineRep);
        return comment;
    }

    private static TokenType charSetType() {
        CharSetToken notBracket = new CharSetToken("notBracket", true, '[', ']');
        ChoiceToken setChar = new ChoiceToken("setChar", escapeSequence, notBracket);
        RepeatingToken setOpt = new RepeatingToken("setOpt", setChar, 0, Integer.MAX_VALUE);
        ListToken charSet = new ListToken("charset", obrack, optionalCaret, setOpt, cbrack);
        return charSet;
    }

    private static TokenType charGroupType() {
        CharSetToken notBracket = new CharSetToken("notBracket", true, '[', ']');
        ChoiceToken setChar = new ChoiceToken("setChar", escapeSequence, notBracket);
        StringToken dash = new StringToken("-", "-");
        ListToken charSet = new ListToken("chargroup", obrack, optionalCaret, setChar, dash, setChar, cbrack);
        return charSet;
    }

    private static TokenType quantifierType() {
        StringToken ocbrack = new StringToken("{", "{");
        StringToken ccbrack = new StringToken("}", "}");
        StringToken comma = new StringToken(",", ",");
        RepeatingToken commaOpt = new RepeatingToken(",", comma, 0, 1);
        RepeatingToken numberOpt = new RepeatingToken("number", number, 0, 1);
        ListToken quantifier = new ListToken("modifier", ocbrack, opsep, numberOpt, opsep, commaOpt, opsep, numberOpt, opsep, ccbrack);
        return quantifier;
    }

    private static TokenType tokenType() {
        ChoiceToken tokenBase = new ChoiceToken("tokenBase", BNFLexer.stringType(), BNFLexer.charGroupType(), BNFLexer.charSetType(), word, eofToken);
        ListToken realToken = new ListToken("token", notOpt, tokenBase, modifierToken);
        return realToken;
    }

    private static TokenType statementType() {
        statement = new PlaceholderToken("statement");
        ListToken nested = new ListToken("nested", notOpt, oparen, statement, cparen, modifierToken);
        StringToken bar = new StringToken("|", "|");
        ListToken barSepOpt = new ListToken("|", opsep, bar, opsep);
        ChoiceToken separatorChoice = new ChoiceToken("separator", barSepOpt, sep);
        ChoiceToken tokenOrStatement = new ChoiceToken("tokenOrStatement", token, statement, nested);
        ListToken restList = new ListToken("statementList", separatorChoice, tokenOrStatement);
        RepeatingToken restRep = new RepeatingToken("statementOpt", restList, 0, Integer.MAX_VALUE);
        ChoiceToken tokenOrNestedStatement = new ChoiceToken("tokenOrNested", token, nested);
        ListToken statement = new ListToken("statement", tokenOrNestedStatement, restRep);
        HashMap<String, TokenType> map = new HashMap<String, TokenType>();
        map.put("statement", statement);
        statement.replacePlaceholders(map);
        return statement;
    }

    private static TokenType rootType() {
        ChoiceToken sepOrEnd = new ChoiceToken("sep", newlineRep, new EndOfFileToken("eof"));
        ChoiceToken line = new ChoiceToken("line", comment, sentence);
        ListToken sentenceList = new ListToken("sentences", line, sepOrEnd);
        RepeatingToken sentenceRep = new RepeatingToken("sentencesRep", sentenceList);
        sentenceRep.replacePlaceholders(Collections.emptyMap());
        return sentenceRep;
    }
}

