/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.spigot;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import redempt.ordinate.command.CommandBase;
import redempt.ordinate.dispatch.CommandRegistrar;

public class SpigotCommandRegistrar
implements CommandRegistrar<CommandSender> {
    private Map<String, Command> knownCommands;
    private CommandMap commandMap;
    private String fallbackPrefix;
    private Plugin plugin;

    public static Command createSpigotCommand(final CommandBase<CommandSender> command) {
        final List<String> aliases = command.getNames();
        return new Command(command.getCommands().get(0).getName()){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                command.execute(sender, args);
                return false;
            }

            public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
                return command.getCompletions(sender, args).getCompletions();
            }

            public List<String> getAliases() {
                return aliases;
            }
        };
    }

    SpigotCommandRegistrar(Plugin plugin, String fallbackPrefix) {
        this.fallbackPrefix = fallbackPrefix;
        this.initKnownCommands();
        this.plugin = plugin;
    }

    private void initKnownCommands() {
        try {
            Field field = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            this.commandMap = (SimpleCommandMap)field.get(Bukkit.getPluginManager());
            field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            this.knownCommands = (Map)field.get(this.commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void register(CommandBase<CommandSender> command) {
        Command cmd = SpigotCommandRegistrar.createSpigotCommand(command);
        command.getCommands().forEach(c -> this.commandMap.register(this.fallbackPrefix, cmd));
        Bukkit.getPluginManager().registerEvents((Listener)new UnregisterListener(this.plugin, () -> this.unregister(command)), this.plugin);
    }

    @Override
    public void unregister(CommandBase<CommandSender> command) {
        for (String name : command.getNames()) {
            this.knownCommands.remove(name);
            this.knownCommands.remove(this.fallbackPrefix + ":" + name);
        }
    }

    public static class UnregisterListener
    implements Listener {
        private Plugin plugin;
        private Runnable toRun;

        public UnregisterListener(Plugin plugin, Runnable toRun) {
            this.plugin = plugin;
            this.toRun = toRun;
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent e) {
            if (!e.getPlugin().equals((Object)this.plugin)) {
                return;
            }
            this.toRun.run();
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

