/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.spigot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import redempt.ordinate.builder.BuilderOptions;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;
import redempt.ordinate.creation.DefaultComponentFactory;
import redempt.ordinate.dispatch.CommandManager;
import redempt.ordinate.dispatch.CommandRegistrar;
import redempt.ordinate.help.HelpDisplayer;
import redempt.ordinate.message.MessageProvider;
import redempt.ordinate.message.PropertiesMessageProvider;
import redempt.ordinate.parser.CommandParser;
import redempt.ordinate.parser.TagProcessor;
import redempt.ordinate.parser.metadata.ParserOptions;
import redempt.ordinate.spigot.FormatUtils;
import redempt.ordinate.spigot.PermissionComponent;
import redempt.ordinate.spigot.PlayerOnlyComponent;
import redempt.ordinate.spigot.SpigotCommandBuilder;
import redempt.ordinate.spigot.SpigotCommandRegistrar;
import redempt.ordinate.spigot.SpigotHelpDisplayer;

public class SpigotCommandManager
implements CommandManager<CommandSender> {
    private String fallbackPrefix;
    private CommandRegistrar<CommandSender> registrar;
    private ComponentFactory<CommandSender> componentFactory;
    private MessageProvider<CommandSender> messages;
    private HelpDisplayer<CommandSender> helpDisplayer;
    private BuilderOptions<CommandSender> builderOptions = BuilderOptions.getDefaults();
    private Plugin plugin;

    public static Properties getDefaultMessages() {
        Properties props = new Properties();
        props.setProperty("missingArgument", "&cMissing required argument: %1");
        props.setProperty("invalidArgumentValue", "&cInvalid value for argument %1: %2");
        props.setProperty("executionFailed", "&cCommand execution failed due to an unexpected error. Please report this to an administrator.");
        props.setProperty("tooManyArguments", "&cToo many arguments: Extra %1 argument(s) provided");
        props.setProperty("numberOutsideRange", "&cNumber %1 outside range: %2");
        props.setProperty("contextError", "&c%1");
        props.setProperty("constraintError", "&cConstraint failed for %1: %2");
        props.setProperty("invalidSubcommand", "&cInvalid subcommand: %1");
        props.setProperty("noPermission", "&cYou do not have permission to do that (%1)");
        props.setProperty("playerOnly", "&cThis command must be executed as a player");
        props.setProperty("needItem", "&cYou must be holding an item to do this");
        props.setProperty("helpFormat", "&e%1 &7%2");
        return props;
    }

    public static <V> ContextProvider<CommandSender, V> playerContext(String name, String error, Function<Player, V> provider) {
        return ContextProvider.create(name, error, ctx -> {
            if (!(ctx.sender() instanceof Player)) {
                return null;
            }
            return provider.apply((Player)ctx.sender());
        });
    }

    public static SpigotCommandManager getInstance(Plugin plugin, String fallbackPrefix, Properties messages) {
        PropertiesMessageProvider<CommandSender> messageProvider = new PropertiesMessageProvider<CommandSender>(messages, CommandSender::sendMessage, FormatUtils::color);
        return new SpigotCommandManager(plugin, fallbackPrefix, messageProvider);
    }

    public static SpigotCommandManager getInstance(Plugin plugin, String fallbackPrefix) {
        return SpigotCommandManager.getInstance(plugin, fallbackPrefix, SpigotCommandManager.getDefaultMessages());
    }

    public static SpigotCommandManager getInstance(Plugin plugin, Properties messages) {
        return SpigotCommandManager.getInstance(plugin, plugin.getName().toLowerCase(), messages);
    }

    public static SpigotCommandManager getInstance(Plugin plugin) {
        return SpigotCommandManager.getInstance(plugin, plugin.getName().toLowerCase(), SpigotCommandManager.getDefaultMessages());
    }

    protected SpigotCommandManager(Plugin plugin, String fallbackPrefix, MessageProvider<CommandSender> messages) {
        this.fallbackPrefix = fallbackPrefix;
        this.messages = messages;
        this.registrar = new SpigotCommandRegistrar(plugin, fallbackPrefix);
        this.componentFactory = new DefaultComponentFactory<CommandSender>(messages);
        this.helpDisplayer = new SpigotHelpDisplayer(this.getCommandPrefix(), messages);
        this.plugin = plugin;
        this.applyBuilderTypes();
    }

    public SpigotCommandManager loadMessages() {
        return this.loadMessages(this.plugin.getDataFolder().toPath().resolve("command-messages.properties"));
    }

    public MessageProvider<CommandSender> getMessages() {
        return this.messages;
    }

    public SpigotCommandManager loadMessages(Path path) {
        Properties loaded = SpigotCommandManager.getDefaultMessages();
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE);
                loaded.store(writer, null);
                ((Writer)writer).close();
            }
            BufferedReader reader = Files.newBufferedReader(path);
            loaded.load(reader);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.messages = new PropertiesMessageProvider<CommandSender>(loaded, CommandSender::sendMessage, FormatUtils::color);
        this.componentFactory = new DefaultComponentFactory<CommandSender>(this.messages);
        this.helpDisplayer = new SpigotHelpDisplayer(this.getCommandPrefix(), this.messages);
        return this;
    }

    @Override
    public CommandRegistrar<CommandSender> getRegistrar() {
        return this.registrar;
    }

    @Override
    public HelpDisplayer<CommandSender> getHelpDisplayer() {
        return this.helpDisplayer;
    }

    @Override
    public ComponentFactory<CommandSender> getComponentFactory() {
        return this.componentFactory;
    }

    public BuilderOptions<CommandSender> getBuilderOptions() {
        return this.builderOptions;
    }

    @Override
    public CommandParser<CommandSender> getParser() {
        ParserOptions<CommandSender> parserOptions = ParserOptions.getDefaults(this.getComponentFactory());
        CommandParser<CommandSender> parser = new CommandParser<CommandSender>(parserOptions, this);
        this.applyTagProcessors(parser);
        this.applyArgTypes(parser);
        this.applyContextProviders(parser);
        return parser;
    }

    public SpigotCommandBuilder builder(String ... names) {
        return new SpigotCommandBuilder(names, this, this.builderOptions);
    }

    private void applyTagProcessors(CommandParser<CommandSender> parser) {
        parser.addTagProcessors(TagProcessor.create("permission", (command, arg) -> command.getPipeline().addComponent(new PermissionComponent((String)arg, this.messages.getFormatter("noPermission")))), TagProcessor.create("playerOnly", (command, arg) -> command.getPipeline().addComponent(new PlayerOnlyComponent(this.messages.getFormatter("playerOnly")))));
    }

    private void applyBuilderTypes() {
        this.builderOptions.addType(Player.class, Bukkit::getPlayerExact).completerStream(ctx -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName));
        this.builderOptions.addType(Material.class, s -> Material.getMaterial((String)s)).completerStream((ctx, val) -> Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase));
    }

    private void applyArgTypes(CommandParser<CommandSender> parser) {
        parser.addArgTypes(new ArgType("player", Bukkit::getPlayerExact).completerStream((ctx, val) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName)));
        parser.addArgTypes(new ArgType("world", Bukkit::getWorld).completerStream((ctx, val) -> Bukkit.getWorlds().stream().map(WorldInfo::getName)));
        parser.addArgTypes(new ArgType("material", s -> Material.getMaterial((String)s)).completerStream((ctx, val) -> Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase)));
    }

    private void applyContextProviders(CommandParser<CommandSender> parser) {
        parser.addContextProviders(SpigotCommandManager.playerContext("self", this.messages.getFormatter("playerOnly").format(null, new String[0]).toString(), p -> p));
        parser.addContextProviders(SpigotCommandManager.playerContext("mainHand", this.messages.getFormatter("needItem").format(null, new String[0]).toString(), p -> {
            ItemStack item = p.getInventory().getItemInMainHand();
            return item == null || item.getType() == Material.AIR ? null : item;
        }));
    }

    @Override
    public String getCommandPrefix() {
        return "/";
    }

    public SpigotCommandManager setFallbackPrefix(String fallbackPrefix) {
        this.fallbackPrefix = fallbackPrefix;
        return this;
    }

    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }
}

