/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.spigot;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

class FormatUtils {
    private static Set<Character> colorChars = "4c6e2ab319d5f780rlonmk".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());

    FormatUtils() {
    }

    public static String color(String input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String hexCode;
            char c = input.charAt(i);
            if (i + 1 >= input.length()) {
                builder.append(c);
                continue;
            }
            char n = input.charAt(i + 1);
            if (c == '\\' && (n == '&' || n == '\\')) {
                ++i;
                builder.append(n);
                continue;
            }
            if (c != '&') {
                builder.append(c);
                continue;
            }
            if (colorChars.contains(Character.valueOf(n))) {
                builder.append('\u00a7');
                continue;
            }
            if (n == '#' && i + 7 <= input.length() && (hexCode = input.substring(i + 2, i + 8).toUpperCase(Locale.ROOT)).chars().allMatch(ch -> ch <= 57 && ch >= 48 || ch <= 70 && ch >= 65)) {
                hexCode = Arrays.stream(hexCode.split("")).map(s -> '\u00a7' + s).collect(Collectors.joining());
                builder.append('\u00a7').append("x").append(hexCode);
                i += 7;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

