/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;

public class CommandPipeline<T> {
    private List<CommandComponent<T>> components = new ArrayList<CommandComponent<T>>();
    private Comparator<CommandComponent<T>> comparator;
    private boolean finalized = false;
    private int parsingSlots;
    private int maxArgWidth;
    private int minArgWidth;

    public CommandPipeline() {
        this(Collections.emptyList());
    }

    public CommandPipeline(Collection<CommandComponent<T>> components) {
        this.components.addAll(components);
        this.comparator = Comparator.comparingInt(CommandComponent::getPriority);
        this.comparator = this.comparator.reversed().thenComparing(CommandComponent::getIndex);
        long maxArgWidth = 0L;
        for (CommandComponent<T> component : this.components) {
            this.parsingSlots += component.getMaxParsedObjects();
            maxArgWidth += (long)component.getMaxConsumedArgs();
            this.minArgWidth += component.getMinConsumedArgs();
        }
        this.maxArgWidth = (int)Math.min(Integer.MAX_VALUE, maxArgWidth);
    }

    public List<CommandComponent<T>> getComponents() {
        return this.components;
    }

    public boolean removeComponent(CommandComponent<T> component) {
        return this.components.remove(component);
    }

    public void addComponent(CommandComponent<T> component) {
        if (this.finalized) {
            throw new IllegalStateException("Pipeline already finalized, cannot add more components");
        }
        this.components.add(component);
    }

    public void prepare() {
        if (this.finalized) {
            throw new IllegalStateException("Pipeline already finalized, cannot add more components");
        }
        this.finalized = true;
        this.components.sort(this.comparator);
        int index = 0;
        for (CommandComponent<T> component : this.components) {
            this.parsingSlots += component.getMaxParsedObjects();
            this.minArgWidth += component.getMinConsumedArgs();
            this.maxArgWidth += component.getMaxConsumedArgs();
            component.setIndex(index);
            index += component.getMaxParsedObjects();
        }
        this.components = Collections.unmodifiableList(this.components);
    }

    public CommandResult<T> parse(CommandContext<T> context, Supplier<CommandResult<T>> defaultResult) {
        CommandResult<T> deepestError = null;
        for (CommandComponent<T> component : this.components) {
            CommandResult<T> result = component.parse(context);
            if (result.isComplete()) {
                return result.isSuccess() ? result : CommandResult.deepest(deepestError, result);
            }
            if (result.isSuccess()) continue;
            deepestError = CommandResult.deepest(deepestError, result);
        }
        return deepestError == null ? defaultResult.get() : deepestError;
    }

    public Set<String> completions(CommandContext<T> context) {
        HashSet<String> completions = new HashSet<String>();
        for (CommandComponent<T> component : this.components) {
            CommandResult<T> result = component.complete(context, completions);
            if (result.isSuccess()) continue;
            return completions;
        }
        return completions;
    }

    public int getMaxArgWidth() {
        return this.maxArgWidth;
    }

    public int getMinArgWidth() {
        return this.minArgWidth;
    }

    public int getParsingSlots() {
        return this.parsingSlots;
    }
}

