/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import redempt.ordinate.command.Command;
import redempt.ordinate.command.CommandBase;
import redempt.ordinate.dispatch.CommandManager;

public class CommandCollection<T> {
    private List<CommandBase<T>> commands = new ArrayList<CommandBase<T>>();
    private CommandManager<T> commandManager;

    protected CommandCollection(List<Command<T>> commands, CommandManager<T> commandManager) {
        HashMap<String, List> commandsByName = new HashMap<String, List>();
        commands.forEach(cmd -> commandsByName.computeIfAbsent(cmd.getName(), k -> new ArrayList()).add(cmd));
        commandsByName.forEach((name, cmds) -> this.commands.add(new CommandBase(cmds, commandManager)));
        this.commandManager = commandManager;
    }

    public void register() {
        for (CommandBase<T> cmd : this.commands) {
            this.commandManager.getRegistrar().register(cmd);
        }
    }

    public List<CommandBase<T>> getCommands() {
        return this.commands;
    }
}

