/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import redempt.ordinate.command.Command;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.help.HelpEntry;
import redempt.ordinate.help.HelpPage;

public class HelpBuilder<T> {
    Map<Command<T>, List<HelpComponent>> map = new HashMap<Command<T>, List<HelpComponent>>();
    private Map<Command<T>, List<Predicate<T>>> filters = new HashMap<Command<T>, List<Predicate<T>>>();

    public void addHelp(HelpComponent component) {
        Command cmd = (Command)(component.getOwner() instanceof Command ? component.getOwner() : component.getOwner().getParent());
        this.map.computeIfAbsent(cmd, k -> new ArrayList()).add(component);
    }

    public void addFilter(Command<T> owner, Predicate<T> filter) {
        this.filters.computeIfAbsent(owner, k -> new ArrayList()).add(filter);
    }

    public HelpPage<T> build() {
        LinkedHashMap entries = new LinkedHashMap();
        this.map.forEach((cmd, components) -> entries.put(cmd, this.createEntry((Command<T>)cmd, (List<HelpComponent>)components)));
        return new HelpPage(entries);
    }

    public HelpEntry<T> getPartialEntry(Command<T> cmd) {
        return cmd == null ? null : this.createEntry(cmd, this.map.get(cmd));
    }

    private HelpEntry<T> createEntry(Command<T> owner, List<HelpComponent> components) {
        components.sort(Comparator.comparingInt(h -> -h.getPriority()));
        HelpEntry<T> entry = new HelpEntry<T>(owner, components);
        this.filters.getOrDefault(owner, Collections.emptyList()).forEach(entry::addFilter);
        return entry;
    }
}

