/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.data;

import java.util.HashMap;
import java.util.Map;
import redempt.ordinate.command.Command;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.SplittableList;
import redempt.ordinate.data.SplittableStack;

public class CommandContext<T> {
    private Map<Class<?>, SplittableStack<Object>> dependables = new HashMap();
    private Command<T> command;
    private CommandContext<T> parent;
    private T sender;
    private SplittableList<Argument> args;
    private int initialArgCount;
    private Object[] parsed;

    public CommandContext(Command<T> command, CommandContext<T> parent, T sender, SplittableList<Argument> args, int processAllocation) {
        this.command = command;
        this.parent = parent;
        this.sender = sender;
        this.args = args;
        this.initialArgCount = args.size();
        this.parsed = new Object[processAllocation + 1];
        this.parsed[0] = sender;
    }

    public void provide(Object dependable) {
        this.dependables.computeIfAbsent(dependable.getClass(), k -> new SplittableStack()).push(dependable);
    }

    public <V> void provide(Class<V> clazz, V dependable) {
        this.dependables.computeIfAbsent(clazz, k -> new SplittableStack()).push(dependable);
    }

    public <V> V request(Class<V> clazz, boolean remove) {
        SplittableStack<Object> stack = this.dependables.get(clazz);
        if (stack == null || stack.size() == 0) {
            throw new IllegalStateException("Unable to provide dependency value of type " + clazz.getName());
        }
        return (V)(remove ? stack.pop() : stack.peek());
    }

    public <V> V request(Class<V> clazz) {
        return this.request(clazz, true);
    }

    public boolean hasDependable(Class<?> clazz) {
        return this.dependables.containsKey(clazz);
    }

    public Command<T> getCommand() {
        return this.command;
    }

    public Argument peekArg() {
        return this.args.peek();
    }

    public Argument pollArg() {
        return this.args.poll();
    }

    public void removeArgs(int index, int toRemove, boolean removeInitial) {
        this.args.removeRange(index, toRemove);
        if (removeInitial) {
            this.initialArgCount -= toRemove;
        }
    }

    public void removeArg(int index, boolean removeInitial) {
        this.args.remove(index);
        if (removeInitial) {
            --this.initialArgCount;
        }
    }

    public int initialArgCount() {
        return this.initialArgCount;
    }

    public boolean hasArg() {
        return this.args.hasNext();
    }

    public SplittableList<Argument> getArguments() {
        return this.args;
    }

    public T sender() {
        return this.sender;
    }

    public void setParsed(int pos, Object parsed) {
        this.parsed[pos + 1] = parsed;
    }

    public Object getParsed(int pos) {
        return this.parsed[pos + 1];
    }

    public Object[] getAllParsed() {
        return this.parsed;
    }

    public int getTotalParsingSlots() {
        return this.parsed.length - 1;
    }

    public CommandContext<T> getParent() {
        return this.parent;
    }

    public CommandContext<T> setParent(CommandContext<T> parent) {
        this.parent = parent;
        return this;
    }

    public CommandContext<T> clone(Command<T> command, int argsSplit, int parsingSlots) {
        CommandContext<T> clone = new CommandContext<T>(command, this.parent, this.sender, this.args.split(argsSplit), parsingSlots);
        clone.parent = this;
        this.dependables.forEach((k, v) -> clone.dependables.put((Class<?>)k, v.split()));
        return clone;
    }
}

