/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.creation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.command.Command;
import redempt.ordinate.component.SubcommandLookupComponent;
import redempt.ordinate.component.argument.ArgumentComponent;
import redempt.ordinate.component.argument.ConsumingArgumentComponent;
import redempt.ordinate.component.argument.OptionalArgumentComponent;
import redempt.ordinate.component.argument.VariableLengthArgumentComponent;
import redempt.ordinate.component.flag.BooleanFlagComponent;
import redempt.ordinate.component.flag.FlagComponent;
import redempt.ordinate.constraint.Constraint;
import redempt.ordinate.constraint.ConstraintComponent;
import redempt.ordinate.constraint.ConstraintParser;
import redempt.ordinate.constraint.NumberConstraint;
import redempt.ordinate.context.ContextComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;
import redempt.ordinate.dispatch.CommandDispatcher;
import redempt.ordinate.dispatch.DispatchComponent;
import redempt.ordinate.message.MessageFormatter;
import redempt.ordinate.message.MessageProvider;

public class DefaultComponentFactory<T>
implements ComponentFactory<T> {
    private MessageProvider<T> messages;

    public DefaultComponentFactory(MessageProvider<T> messages) {
        this.messages = messages;
    }

    private MessageFormatter<T> getMessage(String name) {
        return this.messages.getFormatter(name);
    }

    @Override
    public <V> ArgumentComponent<T, V> createArgument(ArgType<T, V> type, String name) {
        return new ArgumentComponent<T, V>(name, type, this.getMessage("missingArgument"), this.getMessage("invalidArgumentValue"));
    }

    @Override
    public <V> OptionalArgumentComponent<T, V> createOptionalArgument(ArgType<T, V> type, ContextProvider<T, V> defaultValue, String name) {
        return new OptionalArgumentComponent<T, V>(name, type, defaultValue, this.getMessage("invalidArgumentValue"), this.getMessage("contextError"));
    }

    @Override
    public <V> ConsumingArgumentComponent<T, V> createConsumingArgument(ArgType<T, V> type, boolean optional, ContextProvider<T, V> defaultValue, String name) {
        return new ConsumingArgumentComponent<T, V>(name, type, optional, defaultValue, this.getMessage("missingArgument"), this.getMessage("invalidArgumentValue"), this.getMessage("contextError"));
    }

    @Override
    public <V> VariableLengthArgumentComponent<T, V> createVariableLengthArgument(ArgType<T, V> type, boolean optional, String name) {
        return new VariableLengthArgumentComponent<T, V>(name, type, optional, this.getMessage("missingArgument"), this.getMessage("invalidArgumentValue"));
    }

    @Override
    public BooleanFlagComponent<T> createBooleanFlag(String ... names) {
        String primaryName = names[0];
        HashSet<String> allNames = new HashSet<String>();
        Collections.addAll(allNames, names);
        return new BooleanFlagComponent(primaryName, allNames);
    }

    @Override
    public <V> FlagComponent<T, V> createFlag(String[] names, ArgType<T, V> type, ContextProvider<T, V> defaultValue) {
        String primaryName = names[0];
        HashSet<String> allNames = new HashSet<String>();
        Collections.addAll(allNames, names);
        return new FlagComponent<T, V>(primaryName, allNames, type, defaultValue, this.getMessage("invalidArgumentValue"), this.getMessage("contextError"), this.getMessage("missingArgument"));
    }

    @Override
    public <V> ContextComponent<T, V> createContext(ContextProvider<T, V> provider, String name) {
        return new ContextComponent<T, V>(name, provider, this.getMessage("contextError"));
    }

    @Override
    public DispatchComponent<T> createDispatch(CommandDispatcher<T> dispatcher) {
        return new DispatchComponent<T>(dispatcher, this.getMessage("tooManyArguments"));
    }

    @Override
    public <V> ConstraintComponent<T, V> createConstraint(Constraint<T, V> constraint, Supplier<Integer> index, String name) {
        return new ConstraintComponent<T, V>(constraint, index, name, this.getMessage("constraintError"));
    }

    @Override
    public SubcommandLookupComponent<T> createLookupComponent(List<Command<T>> commands) {
        return new SubcommandLookupComponent<T>(commands, this.getMessage("invalidSubcommand"));
    }

    @Override
    public <V extends Number> ConstraintParser<T, V> createNumberConstraintParser(Function<String, V> parseNumber) {
        return NumberConstraint.createParser(parseNumber, this.getMessage("numberOutsideRange"));
    }
}

