/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.argument;

import java.util.ArrayList;
import java.util.Set;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.argument.ArgumentComponent;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.message.MessageFormatter;

public class VariableLengthArgumentComponent<T, V>
extends ArgumentComponent<T, V> {
    private boolean optional;

    public VariableLengthArgumentComponent(String name, ArgType<T, V> type, boolean optional, MessageFormatter<T> missingError, MessageFormatter<T> invalidError) {
        super(name, type, missingError, invalidError);
        this.optional = optional;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int getMaxConsumedArgs() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinConsumedArgs() {
        return this.optional ? 0 : 1;
    }

    @Override
    public int getMaxParsedObjects() {
        return 1;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        ArrayList list = new ArrayList();
        boolean hasNext = context.hasArg();
        while (context.hasArg()) {
            String value = context.peekArg().getValue();
            Object parsed = this.getType().convert(context, value);
            if (parsed == null) break;
            context.pollArg();
            list.add(parsed);
        }
        if (list.size() == 0 && !this.optional) {
            if (hasNext) {
                return this.failure(this.getInvalidError().format(context.sender(), this.getName(), context.peekArg().getValue())).complete();
            }
            return this.failure(this.getMissingError().format(context.sender(), this.getName())).complete();
        }
        context.setParsed(this.getIndex(), list);
        return this.success();
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        this.parse(context);
        if (context.getArguments().size() <= 1) {
            completions.addAll(this.getType().complete(context, context.peekArg().getValue()));
        }
        return this.success();
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(new HelpComponent(this, 1, "<" + this.getName() + ">+"));
    }
}

