/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.command;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import redempt.ordinate.command.Command;
import redempt.ordinate.component.HelpSubcommandComponent;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.data.CompletionResult;
import redempt.ordinate.data.Named;
import redempt.ordinate.data.SplittableList;
import redempt.ordinate.dispatch.CommandManager;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpPage;
import redempt.ordinate.processing.ArgumentSplitter;

public class CommandBase<T>
implements Named {
    private List<Command<T>> wrapped;
    private HelpPage<T> help;
    private CommandManager<T> manager;

    public CommandBase(List<Command<T>> wrapped, CommandManager<T> manager) {
        this.wrapped = wrapped;
        HelpBuilder helpBuilder = new HelpBuilder();
        wrapped.forEach(cmd -> cmd.addHelp(helpBuilder));
        this.help = helpBuilder.build();
        this.manager = manager;
    }

    public HelpPage<T> getHelpPage() {
        return this.help;
    }

    public List<Command<T>> getCommands() {
        return this.wrapped;
    }

    @Override
    public String getName() {
        return this.wrapped.get(0).getName();
    }

    public List<String> getNames() {
        return this.wrapped.stream().flatMap(c -> c.getNames().stream()).distinct().collect(Collectors.toList());
    }

    public CompletionResult<T> getCompletions(T sender, String[] args) {
        return this.getCompletions(sender, ArgumentSplitter.split(args, true));
    }

    public CompletionResult<T> getCompletions(T sender, String args) {
        return this.getCompletions(sender, ArgumentSplitter.split(args, true));
    }

    public CompletionResult<T> getCompletions(T sender, SplittableList<Argument> args) {
        LinkedHashSet<String> completions = new LinkedHashSet<String>();
        CommandResult<T> deepestError = null;
        for (Command<T> cmd : this.wrapped) {
            CommandContext<T> context;
            CommandResult<T> result = cmd.complete(context = cmd.createContext(sender, args.split(0)), completions);
            if (result.isSuccess()) continue;
            deepestError = CommandResult.deepest(deepestError, result);
        }
        String last = args.hasNext() ? args.get(args.size() - 1).getValue() : "";
        List<String> fixed = completions.stream().filter(s -> s.regionMatches(true, 0, last, 0, last.length())).map(s -> s.contains(" ") ? '\"' + s.replace("\"", "\\\"") + '\"' : s).collect(Collectors.toList());
        return new CompletionResult(deepestError, fixed);
    }

    public CommandResult<T> execute(T sender, String args) {
        return this.execute(sender, ArgumentSplitter.split(args, false));
    }

    public CommandResult<T> execute(T sender, String[] args) {
        return this.execute(sender, ArgumentSplitter.split(args, false));
    }

    public CommandResult<T> execute(T sender, SplittableList<Argument> args) {
        CommandResult<T> deepestError = null;
        for (Command<T> cmd : this.wrapped) {
            CommandContext<T> context;
            CommandResult<T> result = cmd.parse(context = cmd.createContext(sender, args.split(0)));
            if (result.isSuccess()) {
                return result;
            }
            deepestError = CommandResult.deepest(deepestError, result);
        }
        deepestError.getError().send(sender);
        if (deepestError.getComponent() instanceof Command || deepestError.getComponent() instanceof HelpSubcommandComponent || !deepestError.getComponent().getParent().hasDispatch()) {
            this.manager.getHelpDisplayer().display(sender, this.help.getHelpRecursive(deepestError.getCommand(), true));
        } else {
            this.manager.getHelpDisplayer().display(sender, this.help.getHelp(deepestError.getCommand()));
        }
        return deepestError;
    }
}

