/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import redempt.ordinate.component.SubcommandLookupComponent;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.component.abstracts.CommandParent;
import redempt.ordinate.component.abstracts.HelpProvider;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.data.Named;
import redempt.ordinate.data.SplittableList;
import redempt.ordinate.dispatch.CommandManager;
import redempt.ordinate.dispatch.DispatchComponent;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.help.HelpPage;
import redempt.ordinate.processing.CommandPipeline;

public class Command<T>
extends CommandComponent<T>
implements Named,
HelpProvider<T> {
    private String mainName;
    private Set<String> names = new HashSet<String>();
    private CommandPipeline<T> pipeline;
    private int priority = 20;
    private boolean lookup = true;

    public Command(String[] names, CommandPipeline<T> pipeline) {
        this.mainName = names[0];
        Collections.addAll(this.names, names);
        this.pipeline = pipeline;
    }

    public CommandContext<T> createContext(T sender, SplittableList<Argument> args) {
        return new CommandContext<T>(this, null, sender, args, this.pipeline.getParsingSlots());
    }

    public void setPostArgument() {
        this.lookup = false;
        this.priority = -50;
    }

    public boolean isPostArgument() {
        return this.priority == -50;
    }

    public boolean hasDispatch() {
        return this.pipeline.getComponents().stream().anyMatch(c -> c instanceof DispatchComponent);
    }

    public boolean canLookup() {
        return this.lookup;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public CommandPipeline<T> getPipeline() {
        return this.pipeline;
    }

    public void preparePipeline(CommandManager<T> manager) {
        this.processLookup(manager);
        this.pipeline.getComponents().forEach(c -> c.setParent(this));
        this.pipeline.prepare();
    }

    private void processLookup(CommandManager<T> manager) {
        List<Command<T>> subcommands = this.getSubcommands();
        subcommands.removeIf(c -> !c.canLookup());
        if (!subcommands.isEmpty()) {
            this.getPipeline().getComponents().removeAll(subcommands);
            SubcommandLookupComponent<T> lookup = manager.getComponentFactory().createLookupComponent(subcommands);
            this.getPipeline().addComponent(lookup);
        }
    }

    @Override
    public int getMaxConsumedArgs() {
        return this.pipeline.getMaxArgWidth();
    }

    @Override
    public int getMaxParsedObjects() {
        return this.pipeline.getParsingSlots();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public HelpComponent getHelpComponent() {
        return new HelpComponent(this, 10, this.getName());
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(this.getHelpComponent());
        for (CommandComponent<T> component : this.pipeline.getComponents()) {
            if (!(component instanceof HelpProvider)) continue;
            ((HelpProvider)((Object)component)).addHelp(help);
        }
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        if (this.isRoot()) {
            return this.pipeline.parse(context, this::failure);
        }
        if (!context.hasArg()) {
            return this.success();
        }
        Argument arg = context.peekArg();
        if (arg.isQuoted() || !this.names.contains(arg.getValue())) {
            return this.success();
        }
        CommandContext<T> clone = context.clone(this, 1, this.pipeline.getParsingSlots()).setParent(context);
        CommandResult<T> result = this.pipeline.parse(clone, this::failure);
        if (!result.isSuccess()) {
            result.uncomplete();
        }
        return result;
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        if (this.isRoot()) {
            completions.addAll(this.pipeline.completions(context));
            return this.success();
        }
        if (!this.postArgumentCompleteChecks(context)) {
            return this.success();
        }
        if (context.getArguments().size() == 1) {
            completions.addAll(this.names);
            return this.success();
        }
        Argument arg = context.peekArg();
        if (arg.isQuoted() || !this.names.contains(arg.getValue())) {
            return this.success();
        }
        context = context.clone(this, 1, this.pipeline.getParsingSlots());
        completions.addAll(this.pipeline.completions(context));
        return this.failure();
    }

    private boolean postArgumentCompleteChecks(CommandContext<T> context) {
        if (!this.isPostArgument()) {
            return true;
        }
        Object[] parentParsed = context.getAllParsed();
        return !Arrays.stream(parentParsed).skip(1L).anyMatch(Objects::isNull);
    }

    @Override
    public String getName() {
        return this.mainName;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void getParentPrefix(HelpPage<T> page, List<String> parts) {
        if (this.getParent() != null) {
            this.getParent().getParentPrefix(page, parts);
        }
        if (this.isPostArgument()) {
            parts.add(page.getHelp(this.getParent()).getUsage().split(" ", 2)[1]);
        }
        parts.add(this.getName());
    }

    public List<Command<T>> getSubcommands() {
        ArrayList<Command<T>> subcommands = new ArrayList<Command<T>>();
        for (CommandComponent<T> component : this.pipeline.getComponents()) {
            if (component instanceof Command) {
                subcommands.add((Command)component);
                continue;
            }
            if (!(component instanceof CommandParent)) continue;
            CommandParent parent = (CommandParent)((Object)component);
            subcommands.addAll(parent.getSubcommands());
        }
        return subcommands;
    }
}

