/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.builder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import redempt.ordinate.builder.BuilderOptions;
import redempt.ordinate.builder.CommandArgumentMap;
import redempt.ordinate.builder.CommandArguments;
import redempt.ordinate.builder.CommandBuilderFactory;
import redempt.ordinate.command.Command;
import redempt.ordinate.command.CommandBase;
import redempt.ordinate.command.postarg.PostArgumentSubcommand;
import redempt.ordinate.component.DescriptionComponent;
import redempt.ordinate.component.HelpSubcommandComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.dispatch.CommandDispatcher;
import redempt.ordinate.dispatch.CommandManager;
import redempt.ordinate.processing.CommandPipeline;

public class CommandBuilder<T, B extends CommandBuilder<T, B>> {
    protected CommandPipeline<T> pipeline = new CommandPipeline();
    protected CommandManager<T> manager;
    protected ComponentFactory<T> componentFactory;
    protected List<Runnable> deferred = new ArrayList<Runnable>();
    private BuilderOptions<T> options;
    private CommandBuilderFactory<T, B> builderFactory;
    private String[] names;
    private boolean postArg;

    public CommandBuilder(String[] names, CommandManager<T> manager, BuilderOptions<T> options, CommandBuilderFactory<T, B> builderFactory) {
        this.manager = manager;
        this.componentFactory = manager.getComponentFactory();
        this.names = names;
        this.options = options;
        this.builderFactory = builderFactory;
        if (options.getHelpSubcommandName() != null) {
            this.pipeline.addComponent(new HelpSubcommandComponent(options.getHelpSubcommandName()));
        }
    }

    public B help(String help) {
        this.pipeline.addComponent(new DescriptionComponent(help));
        return (B)this;
    }

    public B arg(Class<?> type, String name) {
        if (type.isArray()) {
            this.pipeline.addComponent(this.componentFactory.createVariableLengthArgument(this.options.getType(type.getComponentType()), false, name));
        } else {
            this.pipeline.addComponent(this.componentFactory.createArgument(this.options.getType(type), name));
        }
        return (B)this;
    }

    public <V> B consumingArg(Class<V> type, String name, boolean optional, Function<CommandContext<T>, V> defaultValue) {
        ContextProvider<T, V> context = defaultValue == null ? null : ContextProvider.create(null, "Failed to get default value for " + name, defaultValue);
        this.pipeline.addComponent(this.componentFactory.createConsumingArgument(this.options.getType(type), optional, context, name));
        return (B)this;
    }

    public <V> B consumingArg(Class<V> type, String name) {
        return this.consumingArg(type, name, false, ctx -> null);
    }

    public <V> B optionalArg(Class<V> type, String name, Function<CommandContext<T>, V> defaultValue) {
        ContextProvider<T, V> context;
        ContextProvider<T, V> contextProvider = context = defaultValue == null ? null : ContextProvider.create(null, "Failed to get default value for " + name, defaultValue);
        if (type.isArray()) {
            this.pipeline.addComponent(this.componentFactory.createVariableLengthArgument(this.options.getType(type.getComponentType()), true, name));
        } else {
            this.pipeline.addComponent(this.componentFactory.createOptionalArgument(this.options.getType(type), context, name));
        }
        return (B)this;
    }

    public B subcommand(String[] names, Consumer<B> consumer) {
        B builder = this.builderFactory.create(names, this.manager, this.options);
        ((CommandBuilder)builder).deferred = this.deferred;
        consumer.accept(builder);
        this.pipeline.addComponent(((CommandBuilder)builder).build());
        return (B)this;
    }

    public B subcommand(String name, Consumer<B> consumer) {
        return this.subcommand(new String[]{name}, consumer);
    }

    public B noHelpSubcommand() {
        this.pipeline.getComponents().removeIf(c -> c instanceof HelpSubcommandComponent);
        return (B)this;
    }

    public B handler(Consumer<CommandArguments<T>> handler) {
        this.pipeline.addComponent(this.componentFactory.createDispatch(new BuilderDispatcher<T>(handler)));
        return (B)this;
    }

    public B boolFlag(String ... names) {
        this.pipeline.addComponent(this.componentFactory.createBooleanFlag(names));
        return (B)this;
    }

    public B postArgument() {
        this.postArg = true;
        return (B)this;
    }

    protected Command<T> build() {
        Command cmd = new Command(this.names, this.pipeline);
        cmd.getPipeline().getComponents().forEach(c -> c.setParent(cmd));
        if (this.postArg) {
            this.deferred.add(() -> PostArgumentSubcommand.makePostArgument(cmd));
        }
        return cmd;
    }

    public CommandBase<T> register() {
        Command<T> command = this.build();
        ArrayDeque queue = new ArrayDeque();
        queue.add(command);
        this.deferred.forEach(Runnable::run);
        while (!queue.isEmpty()) {
            Command next = (Command)queue.poll();
            next.preparePipeline(this.manager);
            queue.addAll(next.getSubcommands());
        }
        CommandBase<T> base = new CommandBase<T>(Collections.singletonList(command), this.manager);
        this.manager.getRegistrar().register(base);
        return base;
    }

    private static class BuilderDispatcher<T>
    implements CommandDispatcher<T> {
        private Map<String, Integer> indexMap = null;
        private Consumer<CommandArguments<T>> consumer;

        public BuilderDispatcher(Consumer<CommandArguments<T>> consumer) {
            this.consumer = consumer;
        }

        private void initMap(Command<T> cmd) {
            if (this.indexMap != null) {
                return;
            }
            this.indexMap = CommandArgumentMap.getMap(cmd);
        }

        @Override
        public void dispatch(CommandContext<T> context) {
            this.initMap(context.getCommand());
            CommandArguments<T> args = new CommandArguments<T>(context.sender(), context.getAllParsed(), this.indexMap);
            this.consumer.accept(args);
        }
    }
}

