/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.processing.MiscUtils;

public class BuilderOptions<T> {
    private Map<Class<?>, ArgType<T, ?>> types = new HashMap();
    private String helpSubcommandName = "help";

    public static <T> BuilderOptions<T> getDefaults() {
        BuilderOptions<T> options = new BuilderOptions<T>();
        options.addType(Integer.class, (String s) -> Integer.parseInt(s));
        options.addType(Long.class, (String s) -> Long.parseLong(s));
        options.addType(Double.class, Double::parseDouble);
        options.addType(Float.class, Float::parseFloat);
        options.addType(String.class, (String s) -> s);
        options.addType(Boolean.class, MiscUtils::parseBoolean).completer(ctx -> Arrays.asList("true", "false"));
        return options;
    }

    public void setHelpSubcommandName(String name) {
        this.helpSubcommandName = name;
    }

    public <V> ArgType<T, V> addType(Class<V> clazz, Function<String, V> converter) {
        ArgType argType = new ArgType(clazz.getSimpleName().toLowerCase(), converter);
        this.types.put(clazz, argType);
        return argType;
    }

    public <V> ArgType<T, V> addType(Class<V> clazz, BiFunction<CommandContext<T>, String, V> converter) {
        ArgType<T, V> argType = new ArgType<T, V>(clazz.getSimpleName().toLowerCase(), converter);
        this.types.put(clazz, argType);
        return argType;
    }

    public ArgType<T, ?> getType(Class<?> clazz) {
        return this.getOrError(this.types, clazz, () -> "No argument type defined for " + clazz.getName());
    }

    public String getHelpSubcommandName() {
        return this.helpSubcommandName;
    }

    private <K, V> V getOrError(Map<K, V> map, K key, Supplier<String> error) {
        V value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException(error.get());
        }
        return value;
    }
}

