/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class ListToken
extends TokenType
implements ParentToken {
    private TokenType[] children;
    private int minLength = -1;

    public ListToken(String name, TokenType ... children) {
        super(name);
        this.children = children;
    }

    private void initLength() {
        if (this.minLength != -1) {
            return;
        }
        this.minLength = 0;
        for (TokenType child : this.children) {
            this.minLength += child.minLength();
        }
    }

    @Override
    protected Token findForward(String str, int pos, LexContext ctx) {
        Token[] arr = new Token[this.children.length];
        int start = pos;
        for (int i = 0; i < this.children.length; ++i) {
            Token inst = this.children[i].tryTokenize(str, pos, ctx);
            if (inst == null) {
                return null;
            }
            arr[i] = inst;
            pos += arr[i].length();
        }
        return new Token(this, str, start, pos, arr);
    }

    @Override
    public int minLength() {
        this.initLength();
        return this.minLength;
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        int i;
        HashSet<Character> chars = new HashSet<Character>();
        for (i = 0; i < this.children.length && this.children[i].minLength() == 0; ++i) {
            chars.addAll(this.children[i].getFirstCharacters());
        }
        if (i < this.children.length) {
            chars.addAll(this.children[i].getFirstCharacters());
        }
        return new ArrayList<Character>(chars);
    }

    @Override
    public TokenType[] getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(TokenType[] children) {
        this.children = children;
    }
}

