/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.parser.argument;

import java.util.ArrayList;
import java.util.List;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.constraint.Constraint;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;

public class ArgumentBuilder<T, V> {
    private String name;
    private boolean optional;
    private boolean vararg;
    private boolean consuming;
    private ArgType<T, V> type;
    private Constraint<T, ?> constraint;
    private ContextProvider<T, V> defaultValue;

    public void setConsuming(boolean consuming) {
        this.consuming = consuming;
    }

    public void setVararg(boolean vararg) {
        this.vararg = vararg;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(ArgType<T, ?> type) {
        this.type = type;
    }

    public void setConstraint(Constraint<T, ?> constraint) {
        this.constraint = constraint;
    }

    public void setDefaultValue(ContextProvider<T, ?> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<CommandComponent<T>> build(ComponentFactory<T> factory) {
        if (this.vararg && this.consuming) {
            throw new IllegalStateException("Argument cannot be consuming and vararg");
        }
        ArrayList<CommandComponent<T>> list = new ArrayList<CommandComponent<T>>();
        if (this.consuming) {
            list.add(factory.createConsumingArgument(this.type, this.optional, this.defaultValue, this.name));
        } else if (this.vararg) {
            list.add(factory.createVariableLengthArgument(this.type, this.optional, this.name));
            if (this.constraint != null) {
                this.constraint = Constraint.listConstraint(this.constraint);
            }
        } else if (this.optional) {
            list.add(factory.createOptionalArgument(this.type, this.defaultValue, this.name));
        } else {
            list.add(factory.createArgument(this.type, this.name));
        }
        if (this.constraint != null) {
            CommandComponent component = (CommandComponent)list.get(0);
            list.add(factory.createConstraint(this.constraint, component::getIndex, this.name));
        }
        return list;
    }
}

