/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.data;

import java.util.Arrays;

public class SplittableList<T> {
    private Object[] array;
    private int start;

    public SplittableList(T[] array, int start) {
        this.array = array;
        this.start = start;
    }

    public SplittableList(T[] array) {
        this(array, 0);
    }

    public void removeRange(int index, int toRemove) {
        int trueIndex = index + this.start;
        Object[] newArray = new Object[this.array.length - this.start - toRemove];
        System.arraycopy(this.array, this.start, newArray, 0, index);
        System.arraycopy(this.array, trueIndex + toRemove, newArray, index, this.array.length - trueIndex - toRemove);
        this.array = newArray;
        this.start = 0;
    }

    public void remove(int index) {
        this.removeRange(index, 1);
    }

    public void skip(int amount) {
        this.start += amount;
        this.start = Math.min(this.start, this.array.length);
    }

    public T peek() {
        if (this.hasNext()) {
            return (T)this.array[this.start];
        }
        return null;
    }

    public T poll() {
        T val = this.peek();
        if (val != null) {
            ++this.start;
        }
        return val;
    }

    public boolean hasNext() {
        return this.start < this.array.length;
    }

    public int size() {
        return this.array.length - this.start;
    }

    public T get(int index) {
        return (T)this.array[this.start + index];
    }

    public SplittableList<T> split(int newStart) {
        return new SplittableList<Object>(this.array, this.start + newStart);
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOfRange(this.array, this.start, this.array.length));
    }
}

