/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.data;

import redempt.ordinate.command.Command;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.message.Message;

public class CommandResult<T> {
    private CommandComponent<T> component;
    private Message<T> error;
    private boolean complete = false;

    public static <T> CommandResult<T> deepest(CommandResult<T> first, CommandResult<T> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.component.getDepth() >= second.component.getDepth() ? first : second;
    }

    public CommandResult(CommandComponent<T> component, Message<T> error) {
        this.component = component;
        this.error = error;
    }

    public CommandComponent<T> getComponent() {
        return this.component;
    }

    public Command<T> getCommand() {
        if (this.component instanceof Command) {
            return (Command)this.component;
        }
        return this.component.getParent();
    }

    public CommandResult<T> complete() {
        this.complete = true;
        return this;
    }

    public CommandResult<T> uncomplete() {
        this.complete = false;
        return this;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Message<T> getError() {
        return this.error;
    }

    public String toString() {
        return (this.complete ? "Complete " : "Incomplete ") + (this.isSuccess() ? "Success" : "Error: " + this.error);
    }
}

