/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.flag;

import java.util.Set;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.data.Named;
import redempt.ordinate.data.SplittableList;
import redempt.ordinate.message.MessageFormatter;

public class FlagComponent<T, V>
extends CommandComponent<T>
implements Named {
    private Set<String> names;
    private String mainName;
    private ArgType<T, V> type;
    private ContextProvider<T, V> defaultValue;
    private MessageFormatter<T> invalidArgument;
    private MessageFormatter<T> contextError;
    private MessageFormatter<T> noArgument;

    public FlagComponent(String mainName, Set<String> names, ArgType<T, V> type, ContextProvider<T, V> defaultValue, MessageFormatter<T> invalidArgument, MessageFormatter<T> contextError, MessageFormatter<T> noArgument) {
        this.names = names;
        this.mainName = mainName;
        this.type = type;
        this.invalidArgument = invalidArgument;
        this.contextError = contextError;
        this.noArgument = noArgument;
        this.defaultValue = defaultValue;
    }

    @Override
    public int getMaxConsumedArgs() {
        return 2;
    }

    @Override
    public int getMaxParsedObjects() {
        return 1;
    }

    @Override
    public int getMinConsumedArgs() {
        return 0;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        SplittableList<Argument> arguments = context.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            String value = arg.getValue();
            if (arg.isQuoted() || !this.names.contains(value)) continue;
            context.removeArg(i, true);
            return this.handleFlag(context, i);
        }
        return this.handleDefault(context);
    }

    private int find(CommandContext<T> context) {
        for (int i = 0; i < context.getArguments().size(); ++i) {
            Argument arg = context.getArguments().get(i);
            if (arg.isQuoted() || !this.names.contains(arg.getValue())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        int pos = this.find(context);
        int argCount = context.getArguments().size();
        if (pos != -1 && pos < argCount - 2) {
            this.parse(context);
            return this.success();
        }
        if (argCount == 1) {
            Argument arg = context.peekArg();
            if (arg.isQuoted() || !arg.getValue().startsWith("-")) {
                return this.success();
            }
            completions.add(this.getName());
        } else if (argCount == 2) {
            completions.addAll(this.type.complete(context, context.getArguments().get(argCount - 1).getValue()));
        }
        return this.success();
    }

    private CommandResult<T> handleDefault(CommandContext<T> context) {
        if (this.defaultValue == null) {
            return this.success();
        }
        V val = this.defaultValue.provide(context);
        if (val == null) {
            return this.failure(this.contextError.format(context.sender(), this.defaultValue.getError())).complete();
        }
        context.setParsed(this.getIndex(), val);
        return this.success();
    }

    private CommandResult<T> handleFlag(CommandContext<T> context, int i) {
        if (i >= context.getArguments().size()) {
            return this.failure(this.noArgument.format(context.sender(), this.getName())).complete();
        }
        String next = context.getArguments().get(i).getValue();
        context.removeArg(i, true);
        V val = this.type.convert(context, next);
        if (val == null) {
            return this.failure(this.invalidArgument.format(context.sender(), this.getName())).complete();
        }
        context.setParsed(this.getIndex(), val);
        return this.success();
    }

    @Override
    public String getName() {
        return this.mainName;
    }
}

