/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.argument;

import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.argument.ArgumentComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.message.MessageFormatter;

public class OptionalArgumentComponent<T, V>
extends ArgumentComponent<T, V> {
    private ContextProvider<T, V> defaultValue;
    private MessageFormatter<T> contextError;

    public OptionalArgumentComponent(String name, ArgType<T, V> type, ContextProvider<T, V> defaultValue, MessageFormatter<T> invalidError, MessageFormatter<T> contextError) {
        super(name, type, null, invalidError);
        this.defaultValue = defaultValue;
        this.contextError = contextError;
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public int getMinConsumedArgs() {
        return 0;
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        int minWidth = context.getCommand().getPipeline().getMinArgWidth();
        int providedArgs = context.initialArgCount();
        if (!context.hasArg() || providedArgs <= minWidth) {
            if (this.defaultValue == null) {
                return this.success();
            }
            V value = this.defaultValue.provide(context);
            if (value == null) {
                return this.failure(this.contextError.format(context.sender(), this.defaultValue.getError())).complete();
            }
            context.setParsed(this.getIndex(), value);
            context.provide(value);
            return this.success();
        }
        String value = context.peekArg().getValue();
        Object parsed = this.getType().convert(context, value);
        if (parsed == null) {
            return this.failure(this.getInvalidError().format(context.sender(), this.getName(), value)).complete();
        }
        context.pollArg();
        context.setParsed(this.getIndex(), parsed);
        context.provide(parsed);
        return this.success();
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(new HelpComponent(this, 1, "[" + this.getName() + "]"));
    }
}

