/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.abstracts;

import java.util.Set;
import redempt.ordinate.command.Command;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.message.Message;

public abstract class CommandComponent<T> {
    private int index;
    private Command<T> parent;
    private int depth;

    public void setParent(Command<T> parent) {
        this.parent = parent;
        this.depth = parent == null ? 0 : parent.getDepth() + 1;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDepth() {
        return this.depth;
    }

    public Command<T> getParent() {
        return this.parent;
    }

    public CommandResult<T> success() {
        return new CommandResult(this, null);
    }

    public CommandResult<T> failure() {
        return this.failure(k -> {});
    }

    public CommandResult<T> failure(Message<T> error) {
        return new CommandResult<T>(this, error);
    }

    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        return this.parse(context);
    }

    public int getMinConsumedArgs() {
        return this.getMaxConsumedArgs();
    }

    public abstract int getMaxConsumedArgs();

    public abstract int getMaxParsedObjects();

    public abstract int getPriority();

    public abstract CommandResult<T> parse(CommandContext<T> var1);
}

