/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import redempt.ordinate.constraint.ConstraintParser;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.Named;

public class ArgType<T, V>
implements Named {
    private String name;
    private BiFunction<CommandContext<T>, String, V> converter;
    private BiFunction<CommandContext<T>, String, Collection<String>> completer = (ctx, s) -> Collections.emptyList();
    private ConstraintParser<T, V> constraintParser;

    public static <T, V> ArgType<T, V> of(String name, Map<String, V> map) {
        return new ArgType<T, Object>(name, (ctx, val) -> map.get(val)).completer((CommandContext<T> ctx, String val) -> map.keySet());
    }

    public ArgType(String name, BiFunction<CommandContext<T>, String, V> converter) {
        this.name = name;
        this.converter = converter;
    }

    public ArgType(String name, Function<String, V> converter) {
        this(name, (CommandContext<T> ctx, String val) -> converter.apply((String)val));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public V convert(CommandContext<T> context, String arg) {
        try {
            return this.converter.apply(context, arg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<String> complete(CommandContext<T> context, String partial) {
        return this.completer.apply(context, partial);
    }

    public ArgType<T, V> constraint(ConstraintParser<T, V> constraintParser) {
        this.constraintParser = constraintParser;
        return this;
    }

    public ArgType<T, V> completer(BiFunction<CommandContext<T>, String, Collection<String>> completer) {
        this.completer = completer;
        return this;
    }

    public ArgType<T, V> completer(Function<CommandContext<T>, Collection<String>> completer) {
        this.completer = (c, s) -> (Collection)completer.apply((CommandContext)c);
        return this;
    }

    public ArgType<T, V> completerStream(BiFunction<CommandContext<T>, String, Stream<String>> completer) {
        this.completer = (ctx, str) -> ((Stream)completer.apply((CommandContext)ctx, (String)str)).collect(Collectors.toList());
        return this;
    }

    public ArgType<T, V> completerStream(Function<CommandContext<T>, Stream<String>> completer) {
        this.completer = (ctx, str) -> ((Stream)completer.apply((CommandContext)ctx)).collect(Collectors.toList());
        return this;
    }

    public ConstraintParser<T, V> getConstraintParser() {
        return this.constraintParser;
    }
}

