/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.data;

public class LongStackSet {
    private long[] stack = new long[100];
    private long[] set = new long[130];
    private int size;

    public boolean add(long value) {
        this.addToStack(value);
        boolean contained = this.addToSet(value, true);
        ++this.size;
        return contained;
    }

    public long pop() {
        long last = this.stack[this.size - 1];
        --this.size;
        this.removeFromSet(last);
        return last;
    }

    public int size() {
        return this.size;
    }

    private void addToStack(long value) {
        if (this.size >= this.stack.length) {
            this.growStack();
        }
        this.stack[this.size] = value;
    }

    private void removeFromSet(long value) {
        int hash;
        int index = hash = (int)value % this.set.length;
        while (this.set[index] != value && this.set[index] != 0L) {
            index = this.nextIndex(index);
        }
        if (this.set[index] == 0L) {
            return;
        }
        this.set[index] = 0L;
        index = this.nextIndex(index);
        while (this.set[index] != 0L && this.set[index] % (long)this.set.length == (long)hash) {
            this.set[this.previousIndex((int)index)] = this.set[index];
            this.set[index] = 0L;
            index = this.nextIndex(index);
        }
    }

    public boolean contains(long value) {
        int hash = (int)value % this.set.length;
        while (this.set[hash] != 0L && this.set[hash] != value) {
            hash = this.nextIndex(hash);
        }
        return this.set[hash] == value;
    }

    private int previousIndex(int ind) {
        if (--ind < 0) {
            ind = this.set.length - 1;
        }
        return ind;
    }

    private int nextIndex(int ind) {
        if (++ind >= this.set.length) {
            ind = 0;
        }
        return ind;
    }

    private boolean addToSet(long value, boolean checkSize) {
        if (checkSize && (double)((float)this.size / (float)this.set.length) > 0.7) {
            this.growSet();
        }
        int hash = (int)value % this.set.length;
        while (this.set[hash] != 0L && this.set[hash] != value) {
            hash = this.nextIndex(hash);
        }
        boolean contained = this.set[hash] == value;
        this.set[hash] = value;
        return !contained;
    }

    private void growSet() {
        long[] set = this.set;
        this.set = new long[this.set.length * 2];
        for (long num : set) {
            if (num == 0L) continue;
            this.addToSet(num, false);
        }
    }

    private void growStack() {
        long[] copy = new long[this.stack.length * 2];
        System.arraycopy(this.stack, 0, copy, 0, this.stack.length);
        this.stack = copy;
    }
}

