/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.processing;

import java.util.ArrayList;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.SplittableList;

public class ArgumentSplitter {
    public static SplittableList<Argument> split(String[] command, boolean forCompletions) {
        return ArgumentSplitter.split(String.join((CharSequence)" ", command), forCompletions);
    }

    public static SplittableList<Argument> split(String command, boolean forCompletions) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        boolean quoted = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c == '\\' && i + 1 < command.length() && command.charAt(i + 1) == '\"') {
                ++i;
                buffer.append('\"');
                continue;
            }
            if (c == '\"' && (quoted || i == 0 || command.charAt(i - 1) == ' ')) {
                boolean bl = quoted = !quoted;
                if (quoted || buffer.length() <= 0) continue;
                args.add(new Argument(buffer.toString(), true));
                buffer.setLength(0);
                continue;
            }
            if (c == ' ' && !quoted) {
                if (buffer.length() <= 0) continue;
                args.add(new Argument(buffer.toString(), false));
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0 || forCompletions) {
            String[] split;
            String last = buffer.toString();
            last = (quoted ? "\"" : "") + last;
            for (String arg : split = last.split(" ", forCompletions ? -1 : 0)) {
                args.add(new Argument(arg, false));
            }
        }
        Argument[] array = args.toArray(new Argument[0]);
        return new SplittableList<Argument>(array);
    }
}

