/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.parser.argument;

import java.util.ArrayList;
import java.util.List;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.component.flag.FlagComponent;
import redempt.ordinate.constraint.Constraint;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;

public class FlagBuilder<T, V> {
    private String[] names;
    private ArgType<T, V> type;
    private Constraint<T, V> constraint;
    private ContextProvider<T, V> defaultValue;

    public FlagBuilder(String[] names) {
        this.names = names;
    }

    public FlagBuilder<T, V> setType(ArgType<T, ?> type) {
        this.type = type;
        return this;
    }

    public FlagBuilder<T, V> setConstraint(Constraint<T, ?> constraint) {
        this.constraint = constraint;
        return this;
    }

    public FlagBuilder<T, V> setDefaultValue(ContextProvider<T, ?> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public List<CommandComponent<T>> build(ComponentFactory<T> factory) {
        ArrayList<CommandComponent<T>> list = new ArrayList<CommandComponent<T>>();
        FlagComponent<T, V> flag = factory.createFlag(this.names, this.type, this.defaultValue);
        list.add(flag);
        if (this.constraint != null) {
            list.add(factory.createConstraint(this.constraint, flag::getIndex, this.names[0]));
        }
        return list;
    }
}

