/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.parser.argument;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.flag.BooleanFlagComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.creation.ComponentFactory;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.parser.argument.ArgumentBuilder;
import redempt.ordinate.parser.argument.ArgumentParser;
import redempt.ordinate.parser.argument.FlagBuilder;
import redempt.ordinate.parser.metadata.ParserOptions;
import redempt.ordinate.processing.CommandPipeline;
import redempt.redlex.data.Token;

public class DefaultArgumentParser<T>
implements ArgumentParser<T> {
    @Override
    public <V> void parseArgument(Token argument, ParserOptions<T> options, ComponentFactory<T> componentFactory, CommandPipeline<T> pipeline) {
        if (argument.getType().getName().equals("flag")) {
            this.parseFlag(argument, options, componentFactory, pipeline);
            return;
        }
        ArgumentBuilder builder = new ArgumentBuilder();
        Map<String, List<T>> tokens = argument.allByNames("name", "type", "optional", "vararg", "consuming", "constraint", "defaultValue");
        String name = ((Token)DefaultArgumentParser.getDirect(tokens, "name")).getValue();
        builder.setName(name);
        ArgType type = options.getArgType(((Token)DefaultArgumentParser.getDirect(tokens, "type")).getValue());
        builder.setType(type);
        DefaultArgumentParser.getOptional(tokens, "optional").ifPresent(t -> builder.setOptional(true));
        DefaultArgumentParser.getOptional(tokens, "vararg").ifPresent(t -> builder.setVararg(true));
        DefaultArgumentParser.getOptional(tokens, "consuming").ifPresent(t -> builder.setConsuming(true));
        DefaultArgumentParser.getOptional(tokens, "constraint").map(this::trimToken).ifPresent(s -> builder.setConstraint(type.getConstraintParser().parse((String)s)));
        DefaultArgumentParser.getOptional(tokens, "defaultValue").map(this::trimToken).ifPresent(s -> builder.setDefaultValue(this.getDefaultValue(name, type, (String)s, options)));
        builder.build(componentFactory).forEach(pipeline::addComponent);
    }

    private <V> void parseFlag(Token flag, ParserOptions<T> options, ComponentFactory<T> componentFactory, CommandPipeline<T> pipeline) {
        if (flag.getBaseString().charAt(flag.getStart()) == '-') {
            pipeline.addComponent(this.parseBooleanFlag(flag.getValue(), componentFactory));
            return;
        }
        Map<String, List<T>> tokens = flag.allByNames("type", "name", "constraint", "defaultValue");
        String[] names = (String[])tokens.get("name").stream().map(Token::getValue).toArray(String[]::new);
        names[0] = "-" + names[0];
        FlagBuilder builder = new FlagBuilder(names);
        ArgType type = options.getArgType(((Token)DefaultArgumentParser.getDirect(tokens, "type")).getValue());
        builder.setType(type);
        DefaultArgumentParser.getOptional(tokens, "constraint").map(this::trimToken).ifPresent(s -> builder.setConstraint(type.getConstraintParser().parse((String)s)));
        DefaultArgumentParser.getOptional(tokens, "defaultValue").map(this::trimToken).ifPresent(s -> builder.setDefaultValue(this.getDefaultValue(names[0], type, (String)s, options)));
        builder.build(componentFactory).forEach(pipeline::addComponent);
    }

    private BooleanFlagComponent<T> parseBooleanFlag(String value, ComponentFactory<T> componentFactory) {
        String[] split = value.split(",");
        if (Arrays.stream(split).anyMatch(s -> !s.startsWith("-"))) {
            throw new IllegalArgumentException("All flag aliases must begin with a dash");
        }
        return componentFactory.createBooleanFlag(split);
    }

    private ContextProvider<T, ?> getDefaultValue(String name, ArgType<T, ?> type, String str, ParserOptions<T> options) {
        if (str.startsWith("context ")) {
            return options.getContextProvider(str.substring(8));
        }
        return ContextProvider.create(null, "Failed to parse default value for " + name, ctx -> type.convert((CommandContext)ctx, str));
    }

    private String trimToken(Token token) {
        return token.getBaseString().substring(token.getStart() + 1, token.getEnd() - 1);
    }

    private static <T> T getDirect(Map<String, List<T>> map, String key) {
        return map.get(key).get(0);
    }

    private static <T> Optional<T> getOptional(Map<String, List<T>> map, String key) {
        List<T> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }
}

