/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.parser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.dispatch.CommandDispatcher;
import redempt.ordinate.parser.metadata.MethodHook;

public class ReflectiveCommandDispatcher<T>
implements CommandDispatcher<T> {
    private MethodHook hook;
    private List<Consumer<Object[]>> transformers;

    public ReflectiveCommandDispatcher(MethodHook hook) {
        this.hook = hook;
        this.initTransformers();
    }

    private void initTransformers() {
        this.transformers = new ArrayList<Consumer<Object[]>>();
        Class<?>[] types = this.hook.getMethod().getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (!type.isArray()) continue;
            this.transformers.add(this.createArrayTransformer(type.getComponentType(), i));
        }
    }

    private <T> Consumer<Object[]> createArrayTransformer(Class<?> componentType, int slot) {
        return array -> {
            Collection collection = (Collection)array[slot];
            Object arr = Array.newInstance(componentType, collection.size());
            int i = 0;
            for (Object val : collection) {
                Array.set(arr, i++, val);
            }
            array[slot] = arr;
        };
    }

    @Override
    public void dispatch(CommandContext<T> context) {
        Object[] parsed = context.getAllParsed();
        this.transformers.forEach(c -> c.accept(parsed));
        try {
            this.hook.getMethod().invoke(this.hook.getTarget(), parsed);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (Object obj : parsed) {
                joiner.add(obj == null ? "null" : obj.getClass().getName());
            }
            throw new IllegalStateException("Could not pass arguments to method hook " + this.hook.getMethod().getName() + ", types passed: " + joiner);
        }
    }
}

