/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.help;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import redempt.ordinate.command.Command;
import redempt.ordinate.help.HelpEntry;

public class HelpPage<T> {
    private Map<Command<T>, HelpEntry<T>> entries;

    public HelpPage(Map<Command<T>, HelpEntry<T>> entries) {
        this.entries = entries;
        entries.values().forEach(entry -> {
            entry.page = this;
        });
    }

    public HelpEntry<T> getHelp(Command<T> command) {
        return this.entries.get(command);
    }

    public HelpEntry<T>[] getHelpRecursive(Command<T> command, boolean filterDescriptionless) {
        ArrayList<HelpEntry<T>> entries = new ArrayList<HelpEntry<T>>();
        ArrayDeque queue = new ArrayDeque();
        queue.add(command);
        while (!queue.isEmpty()) {
            Command cmd = (Command)queue.pollLast();
            HelpEntry<T> entry = this.getHelp(cmd);
            if (!filterDescriptionless || entry.getDescription() != null) {
                entries.add(entry);
            }
            queue.addAll(cmd.getSubcommands());
        }
        return entries.toArray(new HelpEntry[0]);
    }

    public Collection<HelpEntry<T>> getAll() {
        return this.entries.values();
    }
}

