/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.help;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import redempt.ordinate.command.Command;
import redempt.ordinate.component.DescriptionComponent;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.help.HelpPage;

public class HelpEntry<T> {
    private List<HelpComponent> components;
    private List<Predicate<T>> constraints = new ArrayList<Predicate<T>>();
    private Command<T> owner;
    protected HelpPage<T> page;

    public HelpEntry(Command<T> owner, List<HelpComponent> components) {
        this.owner = owner;
        this.components = components;
    }

    public HelpPage<T> getPage() {
        return this.page;
    }

    public Command<T> getOwner() {
        return this.owner;
    }

    public List<HelpComponent> getComponents() {
        return this.components;
    }

    public void addFilter(Predicate<T> constraint) {
        this.constraints.add(constraint);
    }

    public boolean isVisibleTo(T sender) {
        return this.constraints.stream().allMatch(f -> f.test(sender));
    }

    public String getParentPrefix() {
        ArrayList<String> parentPrefix = new ArrayList<String>();
        this.owner.getParentPrefix(this.getPage(), parentPrefix);
        parentPrefix.remove(parentPrefix.size() - 1);
        return String.join((CharSequence)" ", parentPrefix);
    }

    private boolean isDescription(HelpComponent c) {
        return c.getOwner() instanceof DescriptionComponent;
    }

    public String getUsage() {
        StringJoiner joiner = new StringJoiner(" ");
        this.components.stream().filter(c -> !this.isDescription((HelpComponent)c)).forEach(c -> joiner.add(c.getValue()));
        return joiner.toString();
    }

    public String getDescription() {
        HelpComponent last = this.components.get(this.components.size() - 1);
        return this.isDescription(last) ? last.getValue() : null;
    }

    public String toString() {
        return this.getUsage() + ": " + this.getDescription();
    }
}

