/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.data;

public class SplittableStack<T> {
    private StackNode<T> head;
    private int size;

    public SplittableStack<T> split() {
        SplittableStack<T> clone = new SplittableStack<T>();
        clone.head = this.head;
        clone.size = this.size;
        return clone;
    }

    public void push(T elem) {
        ++this.size;
        StackNode<T> node = new StackNode<T>(elem);
        if (this.head == null) {
            this.head = node;
            return;
        }
        ((StackNode)node).next = (StackNode)this.head;
        this.head = node;
    }

    public T pop() {
        --this.size;
        Object val = ((StackNode)this.head).data;
        this.head = ((StackNode)this.head).next;
        return (T)val;
    }

    public T peek() {
        return (T)(this.head == null ? null : ((StackNode)this.head).data);
    }

    public int size() {
        return this.size;
    }

    private static class StackNode<T> {
        private T data;
        private StackNode<T> next;

        public StackNode(T data) {
            this.data = data;
        }
    }
}

