/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.constraint;

import java.util.function.Function;
import java.util.function.Predicate;
import redempt.ordinate.constraint.ConstraintParser;
import redempt.ordinate.message.MessageFormatter;

public class NumberConstraint {
    public static <T, V extends Number> ConstraintParser<T, V> createParser(Function<String, V> parseNumber, MessageFormatter<T> error) {
        return s -> {
            String[] split = (s = s.replace(" ", "")).split(",", -1);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid constraint syntax: " + s);
            }
            Predicate<Number> lowerBound = n -> true;
            Predicate<Number> upperBound = n -> true;
            String display = s.replaceAll("^,(-?\\d+)", "<=$1").replaceAll("(-?\\d+),$", ">=$1").replace(",", " - ");
            if (split[0].length() != 0) {
                Number lower = (Number)parseNumber.apply(split[0]);
                lowerBound = n -> ((Comparable)((Object)n)).compareTo(lower) >= 0;
            }
            if (split[1].length() != 0) {
                Number upper = (Number)parseNumber.apply(split[1]);
                upperBound = n -> ((Comparable)((Object)n)).compareTo(upper) <= 0;
            }
            Predicate<Number> range = lowerBound.and(upperBound);
            return (ctx, val) -> range.test((Number)val) ? null : error.format(ctx.sender(), val.toString(), "Number outside range: " + display);
        };
    }
}

