/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.flag;

import java.util.Set;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.component.abstracts.HelpProvider;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.data.Named;
import redempt.ordinate.data.SplittableList;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;

public class BooleanFlagComponent<T>
extends CommandComponent<T>
implements Named,
HelpProvider<T> {
    private final Set<String> names;
    private final String mainName;

    public BooleanFlagComponent(String mainName, Set<String> names) {
        this.mainName = mainName;
        this.names = names;
    }

    @Override
    public int getMaxConsumedArgs() {
        return 1;
    }

    @Override
    public int getMinConsumedArgs() {
        return 0;
    }

    @Override
    public String getName() {
        return this.mainName;
    }

    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public int getMaxParsedObjects() {
        return 1;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(new HelpComponent(this, 5, '[' + this.mainName + ']'));
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        SplittableList<Argument> arguments = context.getArguments();
        boolean parsed = false;
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            String value = arg.getValue();
            if (arg.isQuoted() || !this.names.contains(value)) continue;
            parsed = true;
            context.removeArg(i, true);
            break;
        }
        context.setParsed(this.getIndex(), parsed);
        return this.success();
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        int oldSize = context.getArguments().size();
        this.parse(context);
        if (oldSize != context.getArguments().size()) {
            return this.success();
        }
        if (context.getArguments().size() != 1) {
            return this.success();
        }
        Argument arg = context.peekArg();
        if (arg.isQuoted() || !arg.getValue().startsWith("-")) {
            return this.success();
        }
        completions.add(this.getName());
        return this.success();
    }
}

