/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.argument;

import java.util.StringJoiner;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.argument.ArgumentComponent;
import redempt.ordinate.context.ContextProvider;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.message.MessageFormatter;

public class ConsumingArgumentComponent<T, V>
extends ArgumentComponent<T, V> {
    private boolean optional;
    private ContextProvider<T, V> defaultValue;
    private MessageFormatter<T> contextError;

    public ConsumingArgumentComponent(String name, ArgType<T, V> type, boolean optional, ContextProvider<T, V> defaultValue, MessageFormatter<T> missingError, MessageFormatter<T> invalidError, MessageFormatter<T> contextError) {
        super(name, type, missingError, invalidError);
        this.defaultValue = defaultValue;
        this.optional = optional;
        this.contextError = contextError;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int getMaxConsumedArgs() {
        return Integer.MAX_VALUE;
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        if (!context.hasArg() && !this.optional) {
            return this.failure(this.getMissingError().format(context.sender(), this.getName())).complete();
        }
        if (!context.hasArg()) {
            if (this.defaultValue == null) {
                return this.success();
            }
            V value = this.defaultValue.provide(context);
            if (value == null) {
                return this.failure(this.contextError.format(context.sender(), this.defaultValue.getError())).complete();
            }
            context.setParsed(this.getIndex(), value);
            context.provide(value);
        }
        StringJoiner joiner = new StringJoiner(" ");
        while (context.hasArg()) {
            joiner.add(context.pollArg().getValue());
        }
        String value = joiner.toString();
        Object parsed = this.getType().convert(context, value);
        if (parsed == null) {
            return this.failure(this.getInvalidError().format(context.sender(), this.getName(), value)).complete();
        }
        context.setParsed(this.getIndex(), parsed);
        context.provide(parsed);
        return this.success();
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(new HelpComponent(this, 1, "<" + this.getName() + ">+"));
    }
}

