/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component.argument;

import java.util.Set;
import redempt.ordinate.command.ArgType;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.component.abstracts.HelpProvider;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.data.Named;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.help.HelpComponent;
import redempt.ordinate.message.MessageFormatter;

public class ArgumentComponent<T, V>
extends CommandComponent<T>
implements Named,
HelpProvider<T> {
    private String name;
    private ArgType<T, V> type;
    private MessageFormatter<T> missingError;
    private MessageFormatter<T> invalidError;

    public ArgumentComponent(String name, ArgType<T, V> type, MessageFormatter<T> missingError, MessageFormatter<T> invalidError) {
        this.name = name;
        this.type = type;
        this.missingError = missingError;
        this.invalidError = invalidError;
    }

    public boolean isOptional() {
        return false;
    }

    public MessageFormatter<T> getInvalidError() {
        return this.invalidError;
    }

    public MessageFormatter<T> getMissingError() {
        return this.missingError;
    }

    public ArgType<T, V> getType() {
        return this.type;
    }

    public void setType(ArgType<T, ?> type) {
        this.type = type;
    }

    @Override
    public int getMaxConsumedArgs() {
        return 1;
    }

    @Override
    public int getMaxParsedObjects() {
        return 1;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        help.addHelp(new HelpComponent(this, 1, "<" + this.name + ">"));
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        if (!context.hasArg()) {
            return this.failure(this.missingError.format(context.sender(), this.name)).complete();
        }
        String arg = context.pollArg().getValue();
        V val = this.type.convert(context, arg);
        if (val != null) {
            context.setParsed(this.getIndex(), val);
            context.provide(val);
            return this.success();
        }
        return this.failure(this.invalidError.format(context.sender(), this.name, arg)).complete();
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        if (context.getArguments().size() != 1) {
            return this.parse(context);
        }
        String partial = context.pollArg().getValue();
        completions.addAll(this.type.complete(context, partial));
        return this.success();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

