/*
 * Decompiled with CFR 0.152.
 */
package redempt.ordinate.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redempt.ordinate.command.Command;
import redempt.ordinate.component.abstracts.CommandComponent;
import redempt.ordinate.component.abstracts.CommandParent;
import redempt.ordinate.component.abstracts.HelpProvider;
import redempt.ordinate.data.Argument;
import redempt.ordinate.data.CommandContext;
import redempt.ordinate.data.CommandResult;
import redempt.ordinate.help.HelpBuilder;
import redempt.ordinate.message.MessageFormatter;

public class SubcommandLookupComponent<T>
extends CommandComponent<T>
implements HelpProvider<T>,
CommandParent<T> {
    private List<Command<T>> commands;
    private Map<String, List<Command<T>>> lookup = new HashMap<String, List<Command<T>>>();
    private MessageFormatter<T> invalidSubcommand;

    public SubcommandLookupComponent(List<Command<T>> commands, MessageFormatter<T> invalidSubcommand) {
        this.commands = commands;
        this.invalidSubcommand = invalidSubcommand;
        for (Command<T> command : commands) {
            command.getNames().forEach(name -> this.lookup.computeIfAbsent((String)name, k -> new ArrayList()).add(command));
        }
    }

    @Override
    public void setParent(Command<T> parent) {
        super.setParent(parent);
        this.commands.forEach(c -> c.setParent(parent));
    }

    @Override
    public int getMinConsumedArgs() {
        return 0;
    }

    @Override
    public int getMaxConsumedArgs() {
        return 0;
    }

    @Override
    public int getMaxParsedObjects() {
        return 0;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public CommandResult<T> parse(CommandContext<T> context) {
        if (!context.hasArg()) {
            return this.success();
        }
        Argument arg = context.peekArg();
        if (arg.isQuoted() || !this.lookup.containsKey(arg.getValue())) {
            return this.success();
        }
        List<Command<T>> subcommands = this.lookup.get(arg.getValue());
        CommandResult<T> deepestError = null;
        for (Command<T> command : subcommands) {
            CommandResult<T> result = command.parse(context.clone(command, 0, command.getMaxParsedObjects()));
            if (result.isSuccess() && result.isComplete()) {
                return result;
            }
            if (result.isSuccess()) continue;
            deepestError = CommandResult.deepest(deepestError, result);
        }
        return deepestError == null ? this.failure(this.invalidSubcommand.format(context.sender(), arg.getValue())) : deepestError;
    }

    @Override
    public CommandResult<T> complete(CommandContext<T> context, Set<String> completions) {
        if (context.getArguments().size() > 1) {
            Argument arg = context.peekArg();
            if (arg.isQuoted() || !this.lookup.containsKey(arg.getValue())) {
                return this.success();
            }
            List<Command<T>> subcommands = this.lookup.get(arg.getValue());
            for (Command<T> command : subcommands) {
                command.complete(context.clone(command, 0, command.getMaxParsedObjects()), completions);
            }
            return this.success();
        }
        completions.addAll(this.lookup.keySet());
        return this.success();
    }

    @Override
    public void addHelp(HelpBuilder<T> help) {
        this.commands.forEach(c -> c.addHelp(help));
    }

    @Override
    public Collection<Command<T>> getSubcommands() {
        return this.commands;
    }
}

