/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.data;

public class FastNumberParsing {
    public static int parseInt(String input) {
        return FastNumberParsing.parseInt(input, 0, input.length());
    }

    public static int parseInt(String input, int start, int end) {
        if (start == end) {
            throw new NumberFormatException("Zero-length input");
        }
        int i = start;
        boolean negative = false;
        if (input.charAt(i) == '-') {
            negative = true;
            ++i;
        }
        int output = 0;
        while (i < end) {
            char c = input.charAt(i);
            if (c > '9' || c < '0') {
                throw new NumberFormatException("Non-numeric character in input '" + input.substring(start, end) + "'");
            }
            output *= 10;
            output += c - 48;
            ++i;
        }
        return negative ? -output : output;
    }

    public static double parseDouble(String input) {
        return FastNumberParsing.parseDouble(input, 0, input.length());
    }

    public static double parseDouble(String input, int start, int end) {
        if (start == end) {
            throw new NumberFormatException("Zero-length input");
        }
        int i = start;
        boolean negative = false;
        if (input.charAt(start) == '-') {
            negative = true;
            ++i;
        }
        double output = 0.0;
        double after = 0.0;
        int decimal = -1;
        while (i < end) {
            char c = input.charAt(i);
            if (c == '.') {
                if (decimal != -1) {
                    throw new NumberFormatException("Second period in double for input '" + input + "'");
                }
                decimal = i;
            } else {
                if (c > '9' || c < '0') {
                    throw new NumberFormatException("Non-numeric character in input '" + input + "'");
                }
                if (decimal != -1) {
                    after *= 10.0;
                    after += (double)(c - 48);
                } else {
                    output *= 10.0;
                    output += (double)(c - 48);
                }
            }
            ++i;
        }
        return negative ? -output - after : output + (after /= Math.pow(10.0, end - decimal - 1));
    }
}

